<?php
// <c> 2025 Volker Niederastroth
if (session_status() === PHP_SESSION_NONE) session_start();


$FEEDBACK_ROOT = '/feedback';
$cfg_file  = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT . '/feedback_config.json';
$data_file = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT . '/feedback_data.json';
$upload_dir_fs = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT . '/uploads/';

/* === Konfiguration laden === */
$cfg = file_exists($cfg_file) ? json_decode(file_get_contents($cfg_file), true) : [];
$cfg = array_merge([
  'title' => 'Dein Feedback',
  'accent' => '#ff5722',
  'bg' => '#ffffff',
  'text' => '#222222',
  'max_items' => 4,
  'upload_path' => '/feedback/uploads/',// Ändern wenn anders benannt
  'thank_text' => 'Danke für dein Feedback! Dein Beitrag wurde gespeichert und wird nach Prüfung freigeschaltet.',
  'thank_color' => '#ff5722',
  'admin_pass_hash' => $cfg['admin_pass_hash'] ?? password_hash('admin123', PASSWORD_DEFAULT)
], $cfg);

/* === Hilfsfunktionen === */
function fbc_h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function fbc_load($f){ return file_exists($f) ? (json_decode(@file_get_contents($f), true) ?: []) : []; }
function fbc_store_all($f,$arr){ @file_put_contents($f,json_encode($arr,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)); }

/* === Login / CSRF === */
if (empty($_SESSION['admin_csrf'])) $_SESSION['admin_csrf'] = bin2hex(random_bytes(12));
$csrf = $_SESSION['admin_csrf'];
$logged_in = isset($_SESSION['fbc_admin']) && $_SESSION['fbc_admin'] === true;
$login_err = '';

if (!$logged_in && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
  $pw = $_POST['password'] ?? '';
  if (password_verify($pw, $cfg['admin_pass_hash'])) {
    $_SESSION['fbc_admin'] = true;
    $logged_in = true;
  } else $login_err = 'Ungültiges Passwort.';
}

if (isset($_GET['logout'])) {
  unset($_SESSION['fbc_admin']);
  header('Location: '.$_SERVER['PHP_SELF']);
  exit;
}

/* === Aktionen === */
if ($logged_in && $_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!isset($_POST['csrf']) || $_POST['csrf'] !== $csrf) {
    $admin_msg = 'Ungültiges CSRF-Token.';
  } else {
    $all = fbc_load($data_file);
    if (isset($_POST['approve'], $_POST['idx'])) {
      $i = (int)$_POST['idx'];
      if (isset($all[$i])) { $all[$i]['approved'] = true; fbc_store_all($data_file,$all); $admin_msg = 'Eintrag freigegeben.'; }
    }
    if (isset($_POST['delete'], $_POST['idx'])) {
      $i = (int)$_POST['idx'];
      if (isset($all[$i])) {
        if (!empty($all[$i]['image'])) {
          $img = $all[$i]['image'];
          $fs = rtrim($_SERVER['DOCUMENT_ROOT'],'/').$img;
          if (is_file($fs)) @unlink($fs);
        }
        array_splice($all, $i, 1);
        fbc_store_all($data_file,$all);
        $admin_msg = 'Eintrag gelöscht.';
      }
    }
    if (isset($_POST['save_config'])) {
      $cfg['title'] = trim($_POST['title'] ?? $cfg['title']);
      $cfg['accent'] = trim($_POST['accent'] ?? $cfg['accent']);
      $cfg['bg'] = trim($_POST['bg'] ?? $cfg['bg']);
      $cfg['text'] = trim($_POST['text'] ?? $cfg['text']);
      $cfg['max_items'] = max(1,(int)($_POST['max_items'] ?? $cfg['max_items']));
      $cfg['upload_path'] = trim($_POST['upload_path'] ?? $cfg['upload_path']);
      $cfg['thank_text'] = trim($_POST['thank_text'] ?? $cfg['thank_text']);
      $cfg['thank_color'] = trim($_POST['thank_color'] ?? $cfg['thank_color']);
      @file_put_contents($cfg_file,json_encode($cfg,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
      $admin_msg = 'Einstellungen gespeichert.';
    }
    if (isset($_POST['change_pass'])) {
      $p1 = $_POST['new_pass'] ?? '';
      $p2 = $_POST['new_pass2'] ?? '';
      if ($p1==='' || $p1!==$p2) $admin_msg='Passwörter stimmen nicht überein.';
      else {
        $cfg['admin_pass_hash']=password_hash($p1,PASSWORD_DEFAULT);
        @file_put_contents($cfg_file,json_encode($cfg,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
        $admin_msg='Passwort geändert.';
      }
    }
  }
}

$entries = fbc_load($data_file);
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Feedback Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{font-family:Arial;background:#f8f9fa}
.container{max-width:1100px;margin-top:30px}
.card{margin-bottom:1rem}
</style>
</head>
<body>
<div class="container">
  <h1 class="mb-3">Feedback Admin</h1>

<?php if (!$logged_in): ?>
  <?php if ($login_err): ?><div class="alert alert-danger"><?=fbc_h($login_err)?></div><?php endif; ?>
  <div class="card"><div class="card-body">
    <form method="post" class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Passwort</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="col-md-6 align-self-end">
        <button name="login" class="btn btn-primary">Login</button>
      </div>
    </form>
    <p class="mt-3 text-muted">Standardpasswort: <strong>admin123</strong></p>
  </div></div>

<?php else: ?>

  <p><a href="?logout=1" class="btn btn-outline-secondary btn-sm">Logout</a></p>
  <?php if (!empty($admin_msg)): ?><div class="alert alert-info"><?=fbc_h($admin_msg)?></div><?php endif; ?>

  <div class="card">
    <div class="card-header">⚙️ Einstellungen</div>
    <div class="card-body">
      <form method="post" class="row g-3">
        <input type="hidden" name="csrf" value="<?=fbc_h($csrf)?>">
        <div class="col-md-6">
          <label class="form-label">Titel</label>
          <input type="text" name="title" value="<?=fbc_h($cfg['title'])?>" class="form-control">
        </div>
        <div class="col-md-2"><label class="form-label">Akzent</label><input type="color" name="accent" value="<?=fbc_h($cfg['accent'])?>" class="form-control form-control-color"></div>
        <div class="col-md-2"><label class="form-label">Hintergrund</label><input type="color" name="bg" value="<?=fbc_h($cfg['bg'])?>" class="form-control form-control-color"></div>
        <div class="col-md-2"><label class="form-label">Textfarbe</label><input type="color" name="text" value="<?=fbc_h($cfg['text'])?>" class="form-control form-control-color"></div>
        <div class="col-md-3"><label class="form-label">Anzahl / Seite</label><input type="number" name="max_items" value="<?=fbc_h($cfg['max_items'])?>" class="form-control"></div>
        <div class="col-md-6"><label class="form-label">Upload-Pfad</label><input type="text" name="upload_path" value="<?=fbc_h($cfg['upload_path'])?>" class="form-control"></div>
        <div class="col-md-12"><label class="form-label">Danke-Text</label><input type="text" name="thank_text" value="<?=fbc_h($cfg['thank_text'])?>" class="form-control"></div>
        <div class="col-md-3"><label class="form-label">Danke-Farbe</label><input type="color" name="thank_color" value="<?=fbc_h($cfg['thank_color'])?>" class="form-control form-control-color"></div>
        <div class="col-12"><button name="save_config" class="btn btn-primary">Speichern</button></div>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="card-header">🔑 Passwort ändern</div>
    <div class="card-body">
      <form method="post" class="row g-3">
        <input type="hidden" name="csrf" value="<?=fbc_h($csrf)?>">
        <div class="col-md-4"><label class="form-label">Neu</label><input type="password" name="new_pass" class="form-control"></div>
        <div class="col-md-4"><label class="form-label">Wiederholen</label><input type="password" name="new_pass2" class="form-control"></div>
        <div class="col-md-4 align-self-end"><button name="change_pass" class="btn btn-warning">Ändern</button></div>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="card-header">💬 Feedback-Einträge</div>
    <div class="card-body">
      <?php if (empty($entries)): ?>
        <div class="alert alert-secondary">Keine Einträge vorhanden.</div>
      <?php else: ?>
      <div class="table-responsive">
        <table class="table table-striped table-sm align-middle">
          <thead><tr><th>#</th><th>Name</th><th>Kommentar</th><th>⭐</th><th>Bild</th><th>Datum</th><th>OK</th><th>Aktion</th></tr></thead>
          <tbody>
          <?php foreach ($entries as $i=>$e): ?>
            <tr class="<?=(!empty($e['approved'])?'':'table-warning')?>">
              <td><?=$i?></td>
              <td><?=fbc_h($e['name'])?></td>
              <td><?=fbc_h(mb_substr($e['note']??'',0,60))?></td>
              <td><?=intval($e['stars']??0)?></td>
              <td><?php if(!empty($e['image'])):?><a href="<?=fbc_h($e['image'])?>" target="_blank">Bild</a><?php endif;?></td>
              <td><?=date('d.m.Y H:i',strtotime($e['time']??''))?></td>
              <td><?=(!empty($e['approved'])?'✅':'❌')?></td>
              <td>
                <form method="post" class="d-inline">
                  <input type="hidden" name="csrf" value="<?=fbc_h($csrf)?>">
                  <input type="hidden" name="idx" value="<?=$i?>">
                  <?php if(empty($e['approved'])): ?><button name="approve" class="btn btn-success btn-sm">Freigeben</button><?php endif; ?>
                  <button name="delete" class="btn btn-danger btn-sm">Löschen</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>
</div>
</body>
</html>
