<?php
// <c> 2025 Volker Niederastroth
if (session_status() === PHP_SESSION_NONE) session_start();

$FEEDBACK_ROOT_URL = '/feedback';// Pfade und Ordnername anpassen

$cfg_file  = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT_URL . '/feedback_config.json';
$data_file = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT_URL . '/feedback_data.json';
$rate_file = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT_URL . '/rate_limit.json';
$upload_dir_fs  = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . $FEEDBACK_ROOT_URL . '/uploads/';
$upload_dir_url = $FEEDBACK_ROOT_URL . '/uploads/';

/* === Konfiguration === */
$cfg = file_exists($cfg_file) ? json_decode(file_get_contents($cfg_file), true) : [];
if (!is_array($cfg)) $cfg = [];
$cfg = array_merge([
  'title'=>'Dein Feedback',
  'accent'=>'#ff5722',
  'bg'=>'#ffffff',
  'text'=>'#222222',
  'max_items'=>4,
  'thank_text'=>'Danke für dein Feedback! Dein Beitrag wurde gespeichert und wird nach Prüfung freigeschaltet.',// Text kann geändert werden
  'thank_color'=>'#ff5722'
], $cfg);

/* === Helpers === */
function fbc_h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function fbc_load($f){ return file_exists($f) ? (json_decode(@file_get_contents($f), true) ?: []) : []; }
function fbc_save($f,$entry){
  $l=fbc_load($f);
  if(!is_array($l))$l=[];
  $l[]=$entry;
  @file_put_contents($f,json_encode($l,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
}

/* === Rate-Limit === */
function fbc_rate_limit($rate_file,$ip,$limit=10,$window=600){
  $now=time();$r=fbc_load($rate_file);
  if(!isset($r[$ip]))$r[$ip]=[];
  $r[$ip]=array_filter($r[$ip],fn($t)=>$t>$now-$window);
  if(count($r[$ip])>=$limit){@file_put_contents($rate_file,json_encode($r));return false;}
  $r[$ip][]=$now;@file_put_contents($rate_file,json_encode($r));return true;
}

/* === Formular-Verarbeitung === */
$ok=false;$err='';
if($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['fbc_action']??'')==='save'){
  if(empty($_POST['website2'])){
    $ip=$_SERVER['REMOTE_ADDR']??'';
    if(!fbc_rate_limit($rate_file,$ip,10,600)){$err='Zu viele Einreichungen. Bitte später versuchen.';}
    else{
      $name=trim($_POST['name']??'');
      $site=trim($_POST['website']??'');
      $stars=(int)($_POST['stars']??0);
      $note=trim($_POST['note']??'');
      $image_path='';
      if($name==='')$err='Bitte Namen angeben.';
      elseif($stars<1||$stars>5)$err='Bitte 1–5 Sterne wählen.';
      elseif($site!==''&&!filter_var($site,FILTER_VALIDATE_URL))$err='Ungültige URL.';
      else{
        if(isset($_FILES['image'])&&$_FILES['image']['error']===UPLOAD_ERR_OK){
          $allowed=['image/jpeg'=>'jpg','image/png'=>'png','image/gif'=>'gif'];
          $tmp=$_FILES['image']['tmp_name'];$type=@mime_content_type($tmp);
          if(isset($allowed[$type])){
            if($_FILES['image']['size']<=6*1024*1024){// 6MB max. Bildgröße-kann auch erhöht werden
              if(!is_dir($upload_dir_fs))@mkdir($upload_dir_fs,0755,true);
              $fn=uniqid('fb_',true).'.'.$allowed[$type];
              if(@move_uploaded_file($tmp,$upload_dir_fs.$fn))$image_path=$upload_dir_url.$fn;
            }else $err='Bild zu groß (max. 6 MB).';
          }else $err='Nur JPG, PNG oder GIF erlaubt.';
        }
        if(!$err){
          $hash=md5($name.'|'.$site.'|'.$stars.'|'.$note.'|'.$image_path);
          if(isset($_SESSION['last_feedback'])&&$_SESSION['last_feedback']===$hash){$err='Dieses Feedback wurde bereits gesendet.';}
          else{
            $_SESSION['last_feedback']=$hash;
            $entry=[
              'name'=>$name,'site'=>$site,'stars'=>$stars,
              'note'=>mb_substr($note,0,500),'image'=>$image_path,
              'time'=>date('c'),'approved'=>false
            ];
            fbc_save($data_file,$entry);

            /* === Admin-Mail === */
            $to='volker@niederastroth.de';
            $subject='Neues Feedback auf deiner Website';
            $msg="Neues Feedback:\n\nName: $name\nWebsite: $site\nSterne: $stars\nKommentar:\n$note\n\n(Bitte im Admin freischalten)";
            @mail($to,$subject,$msg,"From: noreply@niederastroth.de\r\nContent-Type: text/plain; charset=UTF-8");

            /* === Danke-Seite === */
            echo '<!DOCTYPE html><html><head><meta charset="utf-8"><style>
              body{font-family:Arial;text-align:center;padding:60px;color:#fff;background:'.fbc_h($cfg['thank_color']).';}
              h2{margin-bottom:15px}
            </style><script>
              setTimeout(()=>{window.location.replace(window.location.href.split("#")[0]);},4000);
            </script></head><body>
              <h2>Danke!</h2><p>'.fbc_h($cfg['thank_text']).'</p>
            </body></html>';
            exit;
          }
        }
      }
    }
  }
}

/* === Feedback laden === */
$all=array_reverse(fbc_load($data_file));
$approved=array_values(array_filter($all,fn($e)=>!empty($e['approved'])));
$total=count($approved);
$per=(int)$cfg['max_items'];
$page=max(1,(int)($_GET['page']??1));
$pages=max(1,ceil($total/max(1,$per)));
$items=array_slice($approved,($page-1)*$per,$per);
$self=htmlspecialchars($_SERVER['PHP_SELF']);
$uid='fbc_'.substr(md5(mt_rand()),0,6);
?>

<style>
:root{
  --fbc-accent:<?=fbc_h($cfg['accent'])?>;
  --fbc-bg:<?=fbc_h($cfg['bg'])?>;
  --fbc-text:<?=fbc_h($cfg['text'])?>;
}

/* Hauptkarte */
.<?=$uid?>-card.card{
  background:var(--fbc-bg);
  color:var(--fbc-text);
  border:1px solid rgba(0,0,0,.06);
  border-radius:1rem;
  box-shadow:0 4px 12px rgba(0,0,0,.08);
  font-family:Arial,sans-serif;
}

/* Einzelne Feedback-Karten */
.<?=$uid?>-grid .card{
  background:var(--fbc-bg);
  color:var(--fbc-text);
  border:1px solid rgba(0,0,0,.05);
  border-radius:.75rem;
  box-shadow:0 2px 6px rgba(0,0,0,.08);
  transition:transform .25s ease, box-shadow .25s ease, opacity .6s ease;
  opacity:0;
  transform:translateY(15px);
}
.<?=$uid?>-grid .card.fbc-show{
  animation:fbcFadeIn .6s ease forwards;
}
@keyframes fbcFadeIn{
  to{opacity:1;transform:none;}
}

.<?=$uid?>-grid .card:hover{
  transform:translateY(-6px);
  box-shadow:0 8px 18px rgba(0,0,0,.15);
}

.<?=$uid?>-btn{background:var(--fbc-accent);border-color:var(--fbc-accent);}
.<?=$uid?>-stars{display:inline-flex;gap:6px;cursor:pointer;}
.<?=$uid?>-stars input{display:none;}
.<?=$uid?>-stars label{
  font-size:26px;
  color:#ccc;
  user-select:none;
  transition:color .2s,transform .15s;
}
.<?=$uid?>-stars label.active{color:var(--fbc-accent);}
.<?=$uid?>-stars label:hover{transform:scale(1.2);}
.<?=$uid?>-img{
  width:80px;height:80px;object-fit:cover;border-radius:50%;
  margin-right:10px;box-shadow:0 2px 6px rgba(0,0,0,.1);
}
.<?=$uid?>-note{white-space:pre-wrap;margin-top:.25rem;}
.counter{text-align:right;font-size:.85em;color:#888;}
</style>

<script>
// Karten-Animation sichtbar machen
document.addEventListener("DOMContentLoaded", () => {
  const cards = document.querySelectorAll(".<?=$uid?>-grid .card");
  cards.forEach((card, i) => {
    setTimeout(() => card.classList.add("fbc-show"), 150 * i);
  });
});
</script>




<div class="card <?=$uid?>-card my-4">
  <div class="card-body">
    <h3><?=fbc_h($cfg['title'])?></h3>
    <?php if($err): ?><div class="alert alert-danger"><?=fbc_h($err)?></div><?php endif; ?>

    <details class="mb-4">
      <summary class="btn <?=$uid?>-btn text-white">Feedback schreiben</summary>
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="fbc_action" value="save">
        <input type="text" name="website2" style="display:none">
        <div class="row g-3 mt-2">
          <div class="col-md-6"><label class="form-label">Name *</label>
            <input type="text" name="name" class="form-control" required maxlength="80"></div>
          <div class="col-md-6"><label class="form-label">Webseite</label>
            <input type="url" name="website" class="form-control" placeholder="https://..."></div>
          <div class="col-12"><label class="form-label d-block">Bewertung *</label>
            <div class="<?=$uid?>-stars" data-role="input">
              <?php for($i=1;$i<=5;$i++): ?>
              <input type="radio" id="<?=$uid?>_star<?=$i?>" name="stars" value="<?=$i?>">
              <label for="<?=$uid?>_star<?=$i?>" data-val="<?=$i?>">★</label>
              <?php endfor; ?>
            </div></div>
          <div class="col-12"><label class="form-label">Kommentar</label>
            <textarea name="note" class="form-control" rows="3" maxlength="500" oninput="this.nextElementSibling.textContent=this.value.length+'/500';"></textarea>
            <div class="counter">0/500</div></div>
          <div class="col-12"><label class="form-label">Bild/Logo (max 6 MB)</label>
            <input type="file" name="image" class="form-control" accept="image/png,image/jpeg,image/gif"></div>
          <div class="col-12"><button class="btn <?=$uid?>-btn text-white">Absenden</button></div>
        </div>
      </form>
    </details>

    <?php if($items): ?>
   <div class="row row-cols-1 row-cols-md-3 g-4 <?=$uid?>-grid">
      <?php foreach($items as $it): ?>
      <div class="col"><div class="card h-100 shadow-sm"><div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <?php if(!empty($it['image'])): ?><img src="<?=fbc_h($it['image'])?>" class="<?=$uid?>-img"><?php endif; ?>
          <div><strong><?=fbc_h($it['name'])?></strong><br>
            <div class="<?=$uid?>-stars">
              <?php for($i=1;$i<=5;$i++): ?><label class="<?=($i<=$it['stars']?'active':'')?>">★</label><?php endfor; ?>
            </div></div></div>
        <?php if(!empty($it['note'])): ?><p class="<?=$uid?>-note small"><?=fbc_h($it['note'])?></p><?php endif; ?>
        <?php if(!empty($it['site'])): ?><a href="<?=fbc_h($it['site'])?>" target="_blank">Website besuchen</a><?php endif; ?>
      </div><div class="card-footer small text-muted"><?=date('d.m.Y',strtotime($it['time']))?></div></div></div>
      <?php endforeach; ?>
    </div>
    <?php if($pages>1): ?>
    <nav class="mt-4"><ul class="pagination justify-content-center">
      <li class="page-item <?=($page<=1?'disabled':'')?>"><a class="page-link" href="<?=$self?>?page=<?=max(1,$page-1)?>">« Zurück</a></li>
      <?php for($p=1;$p<=$pages;$p++): ?><li class="page-item <?=($p==$page?'active':'')?>"><a class="page-link" href="<?=$self?>?page=<?=$p?>"><?=$p?></a></li><?php endfor; ?>
      <li class="page-item <?=($page>=$pages?'disabled':'')?>"><a class="page-link" href="<?=$self?>?page=<?=min($pages,$page+1)?>">Weiter »</a></li>
    </ul></nav>
    <?php endif; ?>
    <?php endif; ?>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded",()=>{document.querySelectorAll('.<?=$uid?>-stars[data-role="input"]').forEach(c=>{
 const l=[...c.querySelectorAll('label')];let val=0;function upd(h=0){l.forEach(s=>s.classList.toggle('active',parseInt(s.dataset.val)<= (h||val)));}
 l.forEach(s=>{s.addEventListener('mouseenter',()=>upd(parseInt(s.dataset.val)));s.addEventListener('click',()=>{val=parseInt(s.dataset.val);c.querySelector('input[value="'+val+'"]').checked=true;upd();});});
 c.addEventListener('mouseleave',()=>upd());});});
</script>
