<?php
session_start();

if (!isset($_SESSION['admin'])) {
    die('Kein Zugriff');
}

// Nur POST erlauben
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die('Ungültige Anfrage');
}

// CSRF prüfen
if (
    empty($_POST['csrf_token']) ||
    empty($_SESSION['csrf_token']) ||
    !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])
) {
    die('Ungültiger Sicherheitstoken');
}

$basis = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/';

// DB
$db = new PDO("sqlite:" . __DIR__ . "/db.sqlite");
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// ID aus POST
$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
    die('Ungültige ID');
}

// Kommentar + Antworten löschen
$stmt = $db->prepare("DELETE FROM kommentare WHERE id = ? OR parent_id = ?");
$stmt->execute([$id, $id]);

// Ziel / Version aus POST (oder Fallback)
$ziel = $_POST['ziel'] ?? 'allgemein';
$version = $_POST['version'] ?? '';

// Zurück zum Kommentar-Modal
header(
    'Location: kommentar.php?ziel=' . rawurlencode($ziel) .
    '&version=' . rawurlencode($version)
);
exit;
