<?php
session_set_cookie_params(['path' => '/']);
session_start();

require __DIR__ . '/config.php';

$dir     = $_POST['dir']     ?? '.';
$action  = $_POST['action']  ?? '';
$target  = $_POST['target']  ?? '';
$items   = $_POST['items']   ?? [];

if (!$action || empty($items)) {
    die("Keine Elemente ausgewählt.");
}

try {
    $client = getClient();

    switch ($action) {

        case 'delete':
            foreach ($items as $f) {
                $path = ($dir === '.' ? $f : "$dir/$f");
                $client->delete($path);
            }
            break;

        case 'move':
            foreach ($items as $f) {
                $old = ($dir === '.' ? $f : "$dir/$f");
                $new = ($target === '.' ? $f : "$target/$f");
                $client->move($old, $new);
            }
            break;

        case 'copy':
            foreach ($items as $f) {
                $old = ($dir === '.' ? $f : "$dir/$f");
                $new = ($target === '.' ? $f : "$target/$f");
                $client->copy($old, $new);
            }
            break;

        case 'zip':
            $_POST['items'] = $items;
            require __DIR__ . '/zip.php';
            exit;

        default:
            die("Unbekannte Aktion.");
    }

} catch (Throwable $e) {
    die("Bulk-Fehler: " . htmlspecialchars($e->getMessage()));
}

header("Location: browser.php?dir=" . urlencode($dir));
exit;
