<?php
session_start();
require_once __DIR__ . '/lib/client_factory.php';

if (!isset($_SESSION['fm_host'])) {
    header("Location: index.php");
    exit;
}

$path = $_POST['path'] ?? '';
$dir  = $_POST['dir']  ?? '.';
$mode = trim($_POST['mode'] ?? '');

if ($path === '' || $mode === '') {
    header("Location: browser.php?dir=" . urlencode($dir));
    exit;
}

// "755" → oktal
$modeInt = intval($mode, 8);

try {
    $client = fm_get_client();
    $client->chmod($path, $modeInt);
} catch (Exception $e) {
    die("Fehler: " . htmlspecialchars($e->getMessage()));
}

header("Location: browser.php?dir=" . urlencode($dir));
exit;
