<?php
session_start();
require_once __DIR__ . '/config.php';

if (!isset($_GET['dir'], $_GET['f'])) {
    die("Fehlende Parameter.");
}

$dir  = $_GET['dir'];
$name = $_GET['f'];

// Pfad relativ zum Root
$path = ($dir === '.' ? $name : rtrim($dir, '/') . '/' . $name);

try {
    $client = getClient();
} catch (Exception $e) {
    die("Client-Fehler: " . htmlspecialchars($e->getMessage()));
}

/**
 * 🔥 Rekursiv löschen:
 * - Wenn Datei → delete()
 * - Wenn Ordner → Inhalt durchlaufen, dann Ordner entfernen
 */
function fm_delete_recursive($client, string $path)
{
    // Ordner oder Datei?
    if ($client->isDir($path)) {
        // Ordnerinhalt holen
        $items = $client->listDirectory($path);

        if (is_array($items)) {
            foreach ($items as $it) {
                $name = $it['name'] ?? '';
                if ($name === '' || $name === '.' || $name === '..') continue;

                $subPath = rtrim($path, '/') . '/' . $name;

                if (!empty($it['is_dir'])) {
                    // Unterordner
                    fm_delete_recursive($client, $subPath);
                } else {
                    // Datei
                    $client->delete($subPath);
                }
            }
        }

        // Jetzt ist der Ordner leer → Ordner selbst löschen
        if (method_exists($client, 'deleteDir')) {
            $client->deleteDir($path);
        } else {
            // Fallback: versuchen, als Datei zu löschen
            $client->delete($path);
        }

    } else {
        // Datei
        $client->delete($path);
    }
}

// Ausführen
try {
    fm_delete_recursive($client, $path);
} catch (Throwable $e) {
    die("Löschen fehlgeschlagen: " . htmlspecialchars($e->getMessage()));
}

// Zurück zum Browser
header("Location: browser.php?dir=" . urlencode($dir));
exit;
