<?php
session_start();

// Session-Sicherheit
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_samesite', 'Strict');
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    ini_set('session.cookie_secure', 1);
}

// XSS-geschützter Error
$error = isset($_GET['error']) ? htmlspecialchars($_GET['error'], ENT_QUOTES, 'UTF-8') : '';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>FTP/SFTP Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm">
                <div class="card-header text-center">
                    <h4>Datei-Browser Login</h4>
                </div>
                <div class="card-body">
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?=$error?></div>
                    <?php endif; ?>
                    <form method="post" action="auth.php">
                        <!-- CSRF Token -->
                        <?php
                        if (empty($_SESSION['csrf_token'])) {
                            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
                        }
                        ?>
                        <input type="hidden" name="csrf_token" value="<?=$_SESSION['csrf_token']?>">
                        
                        <div class="mb-3">
                            <label class="form-label">Host</label>
                            <input type="text" name="host" class="form-control" required
                                   value="<?=htmlspecialchars($_SESSION['fm_host'] ?? '', ENT_QUOTES)?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Port (FTP: 21, FTPS: 21, SFTP: 22)</label>
                            <input type="number" name="port" class="form-control" min="1" max="65535"
                                   value="<?=htmlspecialchars($_SESSION['fm_port'] ?? '', ENT_QUOTES)?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Benutzer</label>
                            <input type="text" name="user" class="form-control" required
                                   value="<?=htmlspecialchars($_SESSION['fm_user'] ?? '', ENT_QUOTES)?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Passwort</label>
                            <input type="password" name="pass" class="form-control" required autocomplete="current-password">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Protokoll</label>
                            <select name="proto" class="form-select">
                                <?php
                                $p = $_SESSION['fm_proto'] ?? 'ftp';
                                ?>
                                <option value="ftp"  <?=$p==='ftp'?'selected':''?>>FTP</option>
                                <option value="ftps" <?=$p==='ftps'?'selected':''?>>FTPS</option>
                                <option value="sftp" <?=$p==='sftp'?'selected':''?>>SFTP</option>
                            </select>
                        </div>
                        <button class="btn btn-primary w-100">Verbinden</button>
                    </form>
                </div>
                <div class="card-footer text-muted text-center small">
                    FTP / FTPS / SFTP Browser © 2025 Volker Niederastroth
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>