<?php
session_start();
require_once __DIR__ . '/lib/client_factory.php';

if (!isset($_SESSION['fm_host'])) {
    header("Location: index.php");
    exit;
}

$old = $_GET['old'] ?? '';
$new = $_GET['new'] ?? '';
$dir = $_GET['dir'] ?? '.';

if ($old === '' || $new === '') {
    header("Location: browser.php?dir=" . urlencode($dir));
    exit;
}

$baseDir = rtrim(dirname($old), '/');
if ($baseDir === '.' || $baseDir === '/') {
    $newPath = $new;
} else {
    $newPath = $baseDir . '/' . $new;
}

try {
    $client = fm_get_client();
    $client->rename($old, $newPath);
} catch (Exception $e) {
    die("Fehler: " . htmlspecialchars($e->getMessage()));
}

header("Location: browser.php?dir=" . urlencode($dir));
exit;
