<?php
session_start();

// 1. CSRF-Schutz
if (empty($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    header('Location: index.php?error=' . urlencode('Ungültige Anfrage (CSRF)'));
    exit;
}

// 2. Rate Limiting (einfach)
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$lockfile = sys_get_temp_dir() . '/ftplogin_' . md5($ip);

if (file_exists($lockfile)) {
    $attempts = (int)file_get_contents($lockfile);
    if ($attempts >= 5) {
        $age = time() - filemtime($lockfile);
        if ($age < 300) { // 5 Minuten Sperre
            header('Location: index.php?error=' . urlencode('Zu viele Versuche. Bitte warten.'));
            exit;
        } else {
            unlink($lockfile); // Sperre aufheben
        }
    }
}

// 3. Input-Validierung
$host  = trim($_POST['host']  ?? '');
$user  = trim($_POST['user']  ?? '');
$pass  = $_POST['pass']  ?? '';
$proto = $_POST['proto'] ?? 'ftp';
$port  = (int)($_POST['port'] ?? 0);

if (empty($host) || empty($user) || empty($pass)) {
    header('Location: index.php?error=' . urlencode('Alle Felder erforderlich'));
    exit;
}

if (!in_array($proto, ['ftp', 'ftps', 'sftp'])) {
    header('Location: index.php?error=' . urlencode('Ungültiges Protokoll'));
    exit;
}

// Port setzen
if (!$port) {
    $port = match ($proto) {
        'ftp', 'ftps' => 21,
        'sftp' => 22,
        default => 21
    };
}

// 4. Verbindung testen
try {
    require_once __DIR__ . '/lib/client_factory.php';
    
    // Temporär in Session speichern für Test
    $_SESSION['fm_host']  = $host;
    $_SESSION['fm_user']  = $user;
    $_SESSION['fm_pass']  = $pass; // Verschlüsselung siehe unten
    $_SESSION['fm_proto'] = $proto;
    $_SESSION['fm_port']  = $port;
    
    $client = fm_get_client();
    $client->connect();
    
    // Erfolgreich: Session regenerieren (gegen Session Fixation)
    session_regenerate_id(true);
    
    // Login-Sperre zurücksetzen
    if (file_exists($lockfile)) {
        unlink($lockfile);
    }
    
    header('Location: browser.php');
    exit;
    
} catch (Exception $e) {
    // Fehlgeschlagen: Zähler erhöhen
    $attempts = file_exists($lockfile) ? (int)file_get_contents($lockfile) : 0;
    file_put_contents($lockfile, $attempts + 1);
    
    // Session-Daten löschen
    unset($_SESSION['fm_pass']);
    
    header('Location: index.php?error=' . urlencode('Verbindung fehlgeschlagen: ' . $e->getMessage()));
    exit;
}