<?php
session_set_cookie_params(['path' => '/']);
session_start();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>FTP Login</title>

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: #f2f4f8;
        }
        .login-card {
            max-width: 420px;
            margin: 0 auto;
            margin-top: 8vh;
            border-radius: 12px;
        }
        @media (max-width: 480px) {
            .login-card {
                margin-top: 4vh;
            }
        }
    </style>
</head>
<body>

<div class="container">

    <div class="login-card card shadow">
        <div class="card-header text-center bg-primary text-white py-3">
            <h4 class="mb-0">
                <i class="bi bi-hdd-network"></i>
                FTP Login
            </h4>
        </div>

        <div class="card-body p-4">
            <form action="auth.php" method="post">

                <div class="mb-3">
                    <label class="form-label">Server / Hostname</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-globe"></i></span>
                        <input type="text" name="host" required class="form-control" placeholder="ftp.deine-domain.de" autofocus>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Benutzername</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-person"></i></span>
                        <input type="text" name="user" required class="form-control" placeholder="ftp-user">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Protokoll</label>
                    <select name="proto" class="form-select" required>
                        <option value="ftp">FTP</option>
                        <option value="ftps">FTPS (verschlüsselt)</option>
                    </select>
                </div>

                <button class="btn btn-primary w-100 mt-3">
                    <i class="bi bi-box-arrow-in-right"></i> Weiter
                </button>
            </form>
        </div>
    </div>

</div>

</body>
</html>
