<?php
session_start();
require_once __DIR__ . '/lib/client_factory.php';

if (!isset($_SESSION['fm_host'])) {
    header("Location: index.php");
    exit;
}

$dir  = $_POST['dir']  ?? '.';
$name = trim($_POST['name'] ?? '');

if ($name === '') {
    header("Location: browser.php?dir=" . urlencode($dir));
    exit;
}

$path = ($dir === '.' ? $name : rtrim($dir,'/') . '/' . $name);

try {
    $client = fm_get_client();
    $client->mkdir($path);
} catch (Exception $e) {
    die("Fehler: " . htmlspecialchars($e->getMessage()));
}

header("Location: browser.php?dir=" . urlencode($dir));
exit;
