<?php
session_start();
require __DIR__ . '/config.php';

if (!isset($_POST['dir'], $_POST['file'], $_POST['content'])) {
    die("Fehlende Daten.");
}

$dir     = trim($_POST['dir']);
$file    = trim($_POST['file']);
$content = $_POST['content'];

$path = ($dir === '.' ? $file : "$dir/$file");

try {
    $client = getClient();
    $ok = $client->putFileContents($path, $content);

    if (!$ok) {
        throw new Exception("Speichern fehlgeschlagen.");
    }

    header("Location: edit.php?dir=" . urlencode($dir) . "&f=" . urlencode($file));
    exit;

} catch (Throwable $e) {
    die("Fehler beim Speichern: " . htmlspecialchars($e->getMessage()));
}
