<?php
session_start();

require_once __DIR__ . '/config.php';

$dir = $_POST['dir'] ?? '.';

// Verbindung holen
try {
    $client = getClient();
} catch (Throwable $e) {
    die("Verbindungsfehler: " . htmlspecialchars($e->getMessage()));
}

// Falls keine Dateien hochgeladen wurden
if (!isset($_FILES['files']) || empty($_FILES['files']['name'][0])) {
    header("Location: browser.php?dir=" . urlencode($dir) . "&msg=no_files");
    exit;
}

$errors = [];

foreach ($_FILES['files']['tmp_name'] as $i => $tmpPath) {

    $name = $_FILES['files']['name'][$i];
    $error = $_FILES['files']['error'][$i];

    // Fehler vom Upload selbst prüfen
    if ($error !== UPLOAD_ERR_OK) {
        $errors[] = "$name (Upload-Fehler $error)";
        continue;
    }

    if (!is_uploaded_file($tmpPath)) {
        $errors[] = "$name (keine gültige Upload-Datei)";
        continue;
    }

    $remotePath = ($dir === '.' ? $name : $dir . '/' . $name);

    // Dateiinhalt lesen
    $data = @file_get_contents($tmpPath);
    if ($data === false) {
        $errors[] = "$name (konnte nicht gelesen werden)";
        continue;
    }

    // Datei hochladen (FTP / FTPS / SFTP)
    if (!$client->putFileContents($remotePath, $data)) {
        $errors[] = "$name (Upload fehlgeschlagen)";
    }
}

// Ergebnis anzeigen
if (count($errors) > 0) {
    $msg = urlencode("Fehler: " . implode(', ', $errors));
    header("Location: browser.php?dir=" . urlencode($dir) . "&error=$msg");
    exit;
}

header("Location: browser.php?dir=" . urlencode($dir) . "&msg=upload_ok");
exit;
