<?php
session_set_cookie_params(['path' => '/']);
session_start();

require __DIR__ . '/config.php';

if (!isset($_POST['dir'], $_POST['items'])) {
    die("Fehlende Daten.");
}

$dir   = $_POST['dir'];
$items = $_POST['items'];

$tmpZip = tempnam(sys_get_temp_dir(), "z_") . ".zip";

try {
    $client = getClient();

    $zip = new ZipArchive();
    if ($zip->open($tmpZip, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
        throw new Exception("ZIP konnte nicht erzeugt werden.");
    }

    foreach ($items as $name) {
        $remotePath = ($dir === '.' ? $name : rtrim($dir, '/') . '/' . $name);
        addToZip($client, $zip, $remotePath, $name);
    }

    $zip->close();

} catch (Throwable $e) {
    die("ZIP-Fehler: " . htmlspecialchars($e->getMessage()));
}

header("Content-Type: application/zip");
header("Content-Disposition: attachment; filename=\"paket.zip\"");
header("Content-Length: " . filesize($tmpZip));
readfile($tmpZip);
unlink($tmpZip);
exit;


/**
 * Rekursive ZIP-Funktion
 *
 * $client      = FTP / FTPS / SFTP Client
 * $zip         = ZipArchive Objekt
 * $remotePath  = Original Pfad auf Server (z.B. /httpdocs/img/test.jpg)
 * $zipPath     = Pfad im ZIP (z.B. img/test.jpg)
 */
function addToZip($client, ZipArchive $zip, string $remotePath, string $zipPath)
{
    // 1. Ist es ein Ordner?
    if ($client->isDir($remotePath)) {

        // Ordner im ZIP anlegen
        $zip->addEmptyDir($zipPath);

        // Inhalt holen
        $items = $client->listDirectory($remotePath);

        foreach ($items as $item) {
            $name   = $item['name'];
            $isDir  = $item['is_dir'];

            if ($name === '.' || $name === '..') continue;

            $nextRemote = rtrim($remotePath, '/') . '/' . $name;
            $nextZip    = $zipPath . '/' . $name;

            addToZip($client, $zip, $nextRemote, $nextZip);
        }

        return;
    }

    // 2. Datei einfügen
    $data = $client->getFileContents($remotePath);

    if ($data === false || $data === null) {
        return; // Datei kann nicht gelesen werden
    }

    $zip->addFromString($zipPath, $data);
}
