<?php
// Monat/Jahr bestimmen (aus URL oder heute)
$monat = isset($_GET['monat']) ? (int)$_GET['monat'] : date("m");
$jahr  = isset($_GET['jahr']) ? (int)$_GET['jahr'] : date("Y");

// Ersten und letzten Tag des Monats ermitteln
$ersterTag = new DateTime("$jahr-$monat-01");
$tageImMonat = cal_days_in_month(CAL_GREGORIAN, $monat, $jahr);

// Wochentag des ersten Tages (1=Montag, 7=Sonntag)
$startWochentag = (int)$ersterTag->format("N");

// Events laden
$events = json_decode(file_get_contents("events.json"), true) ?? [];

//  Navigation
$prevMonat = $monat == 1 ? 12 : $monat - 1;
$prevJahr  = $monat == 1 ? $jahr - 1 : $jahr;
$nextMonat = $monat == 12 ? 1 : $monat + 1;
$nextJahr  = $monat == 12 ? $jahr + 1 : $jahr;

// Monatsname (Deutsch)
setlocale(LC_TIME, "de_DE.UTF-8");
$monatsName = strftime("%B %Y", $ersterTag->getTimestamp());
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Vereinskalender</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .kalender-tabelle {
      font-size: 0.9rem;
    }
    
    .kalender-tabelle th {
      text-align: center;
      font-weight: bold;
      padding: 8px 4px;
      font-size: 0.8rem;
    }
    
    .kalender-tabelle td {
      width: 14.28%;
      height: auto;
      min-height: 80px;
      vertical-align: top;
      padding: 0;
      position: relative;
    }
    
    .kalender-feld {
      width: 100%;
      height: 100%;
      min-height: 80px;
      padding: 6px 4px;
      cursor: pointer;
      border-radius: 0;
      display: block;
      text-decoration: none;
      color: inherit;
      transition: background-color 0.2s;
    }
    
    .kalender-feld:hover {
      background: #f0f8ff;
      color: inherit;
      text-decoration: none;
    }
    
    .kalender-feld.has-event {
      background: #e8f4fd;
    }
    
    .kalender-feld.has-event:hover {
      background: #d1ecf1;
    }
    
    .event-badge {
      display: block;
      margin-top: 2px;
      font-size: 0.65rem;
      line-height: 1.1;
      padding: 2px 4px;
      border-radius: 3px;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
    }
    
    .tag-nummer {
      font-weight: bold;
      font-size: 0.9rem;
    }
    
    /* Mobile Optimierungen */
    @media (max-width: 768px) {
      .container {
        padding-left: 10px;
        padding-right: 10px;
      }
      
      .kalender-tabelle {
        font-size: 0.8rem;
      }
      
      .kalender-tabelle th {
        font-size: 0.7rem;
        padding: 6px 2px;
      }
      
      .kalender-tabelle td {
        min-height: 70px;
      }
      
      .kalender-feld {
        min-height: 70px;
        padding: 4px 2px;
      }
      
      .tag-nummer {
        font-size: 0.8rem;
      }
      
      .event-badge {
        font-size: 0.6rem;
        padding: 1px 3px;
        margin-top: 1px;
      }
      
      .navigation-title {
        font-size: 1.3rem;
      }
      
      .btn {
        font-size: 0.8rem;
        padding: 6px 12px;
      }
    }
    
    /* Sehr kleine Bildschirme */
    @media (max-width: 480px) {
      .kalender-tabelle {
        font-size: 0.75rem;
      }
      
      .kalender-tabelle th {
        font-size: 0.65rem;
        padding: 4px 1px;
      }
      
      .kalender-tabelle td {
        min-height: 60px;
      }
      
      .kalender-feld {
        min-height: 60px;
        padding: 3px 1px;
      }
      
      .tag-nummer {
        font-size: 0.75rem;
      }
      
      .event-badge {
        font-size: 0.55rem;
        padding: 1px 2px;
      }
      
      .navigation-title {
        font-size: 1.1rem;
      }
      
      .btn {
        font-size: 0.7rem;
        padding: 4px 8px;
      }
      
      /* Navigation auf sehr kleinen Bildschirmen */
      .nav-container {
        flex-direction: column;
        gap: 10px;
        text-align: center;
      }
      
      .nav-buttons {
        display: flex;
        justify-content: space-between;
        width: 100%;
      }
    }
    
    /* Modal Optimierungen für Mobile */
    @media (max-width: 576px) {
      .modal-dialog {
        margin: 10px;
        max-width: none;
      }
      
      .modal-content {
        border-radius: 10px;
      }
      
      .modal-body {
        padding: 15px;
      }
      
      .modal-title {
        font-size: 1.1rem;
      }
    }
  </style>
</head>

<body class="bg-light">
<div class="container mt-4">

  <div class="d-flex justify-content-between align-items-center mb-3 nav-container">
    <div class="nav-buttons d-flex justify-content-between w-100">
      <a href="?monat=<?= $prevMonat ?>&jahr=<?= $prevJahr ?>" class="btn btn-outline-primary">&laquo; Zurück</a>
      <a href="?monat=<?= $nextMonat ?>&jahr=<?= $nextJahr ?>" class="btn btn-outline-primary">Vor &raquo;</a>
    </div>
    <h2 class="navigation-title text-center w-100 mb-0"><?= ucfirst($monatsName) ?></h2>
  </div>

  <div class="table-responsive">
    <table class="table table-bordered kalender-tabelle bg-white">
      <thead class="table-light">
        <tr>
          <th>Mo</th>
          <th>Di</th>
          <th>Mi</th>
          <th>Do</th>
          <th>Fr</th>
          <th>Sa</th>
          <th>So</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $tag = 1;
        $zellen = 0;
        echo "<tr>";
        // Leere Zellen bis Monatsanfang
        for ($i = 1; $i < $startWochentag; $i++) {
            echo "<td></td>";
            $zellen++;
        }

        // Tage des Monats
        while ($tag <= $tageImMonat) {
            $datum = sprintf("%04d-%02d-%02d", $jahr, $monat, $tag);
            $event = array_filter($events, fn($e) => $e["datum"] === $datum);
            $hasEvent = !empty($event);

            echo "<td>";
            
            if ($hasEvent) {
                echo "<div class='kalender-feld has-event' " . 
                     "data-bs-toggle='modal' data-bs-target='#eventModal' " .
                     "data-events='".json_encode(array_values($event), JSON_HEX_APOS|JSON_HEX_QUOT)."'>";
            } else {
                echo "<div class='kalender-feld'>";
            }
            
            echo "<span class='tag-nummer'>$tag</span>";

            if ($hasEvent) {
                $eventCount = 0;
                foreach ($event as $ev) {
                    // Maximal 2 Events auf mobilen Geräten anzeigen
                    if ($eventCount >= 2) {
                        $remainingCount = count($event) - 2;
                        echo "<span class='badge event-badge bg-secondary'>+$remainingCount weitere</span>";
                        break;
                    }
                    
                    $event_farbe = $ev['farbe'] ?? 'primary';
                    $farb_klassen = [
                        'primary' => 'bg-primary',
                        'success' => 'bg-success', 
                        'danger' => 'bg-danger',
                        'warning' => 'bg-warning text-dark',
                        'info' => 'bg-info text-dark',
                        'secondary' => 'bg-secondary',
                        'dark' => 'bg-dark',
                        'purple' => 'text-white',
                        'pink' => 'text-white', 
                        'teal' => 'text-white'
                    ];
                    
                    $badge_class = $farb_klassen[$event_farbe] ?? 'bg-primary';
                    $custom_style = '';
                    
                    // Für custom Farben die nicht in Bootstrap Standard sind
                    if (in_array($event_farbe, ['purple', 'pink', 'teal'])) {
                        $custom_colors = [
                            'purple' => '#6f42c1',
                            'pink' => '#d63384',
                            'teal' => '#20c997'
                        ];
                        $custom_style = " style='background-color: {$custom_colors[$event_farbe]};'";
                    }
                    
                    // Event-Titel für Mobile verkürzen
                    $titel = htmlspecialchars($ev['titel']);
                    $short_titel = strlen($titel) > 12 ? substr($titel, 0, 12) . '...' : $titel;
                    
                    echo "<span class='badge event-badge $badge_class'$custom_style title='$titel'>$short_titel</span>";
                    $eventCount++;
                }
            }

            echo "</div>";
            echo "</td>";

            $zellen++;
            if ($zellen % 7 == 0) {
                echo "</tr><tr>";
            }
            $tag++;
        }

        // Restliche leere Felder
        while ($zellen % 7 != 0) {
            echo "<td></td>";
            $zellen++;
        }
        echo "</tr>";
        ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="eventModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Termindetails</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
      </div>
      <div class="modal-body" id="eventDetails"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Schließen</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.getElementById('eventModal').addEventListener('show.bs.modal', function (event) {
  let div = event.relatedTarget;
  let details = JSON.parse(div.getAttribute('data-events'));
  let html = "";
  details.forEach((ev, index) => {
    html += `<div class="mb-3">
               <h6 class="fw-bold text-primary">${ev.titel}</h6>
               ${ev.uhrzeit ? `<p class="mb-1"><small class="text-muted">⏰ ${ev.uhrzeit} Uhr</small></p>` : ""}
               <p class="mb-0">${ev.beschreibung}</p>
             </div>`;
    if (index < details.length - 1) {
      html += '<hr>';
    }
  });
  document.getElementById("eventDetails").innerHTML = html;
});

// Touch-Optimierung für bessere Mobile-Erfahrung
document.addEventListener('DOMContentLoaded', function() {
  const kalenderFelder = document.querySelectorAll('.kalender-feld');
  
  kalenderFelder.forEach(feld => {
    feld.addEventListener('touchstart', function() {
      this.style.backgroundColor = '#f0f8ff';
    });
    
    feld.addEventListener('touchend', function() {
      setTimeout(() => {
        this.style.backgroundColor = '';
      }, 150);
    });
  });
});
</script>
</body>
</html>