<?php
date_default_timezone_set('Europe/Berlin');
session_start();
// Live Chat System <c> Volker Niederastroth  Version V1.0 22.10.2025
$dbFile = __DIR__ . '/chat_data.sqlite';
$dsn = "sqlite:$dbFile";
$db = new PDO($dsn);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Tabelle anlegen oder erweitern
$db->exec("CREATE TABLE IF NOT EXISTS messages (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    sender TEXT,
    message TEXT,
    session_id TEXT,
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
)");

// Prüfen, ob Spalte session_id existiert (ältere Version)
$cols = $db->query("PRAGMA table_info(messages)")->fetchAll(PDO::FETCH_COLUMN, 1);
if (!in_array('session_id', $cols)) {
    $db->exec("ALTER TABLE messages ADD COLUMN session_id TEXT");
}

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'send':
        $sender = htmlspecialchars($_POST['sender'] ?? 'Gast');
        $message = htmlspecialchars($_POST['message'] ?? '');
        $session_id = $_POST['session_id'] ?? session_id();
        if ($message !== '') {
           $localTime = date('Y-m-d H:i:s'); // Serverzeit (Europe/Berlin)
$stmt = $db->prepare("INSERT INTO messages (sender, message, session_id, timestamp) VALUES (?, ?, ?, ?)");
$stmt->execute([$sender, $message, $session_id, $localTime]);

        }
        break;
    case 'clear':
        $session_id = $_POST['session_id'] ?? '';
        if ($session_id !== '') {
            $stmt = $db->prepare("DELETE FROM messages WHERE session_id = ?");
            $stmt->execute([$session_id]);
        }
        break;

    case 'get':
        $session_id = $_GET['session_id'] ?? session_id();
        $stmt = $db->prepare("SELECT * FROM messages WHERE session_id = ? ORDER BY id ASC");
        $stmt->execute([$session_id]);
        $msgs = $stmt->fetchAll(PDO::FETCH_ASSOC);
        header('Content-Type: application/json');
        echo json_encode($msgs);
        break;

    case 'sessions':
        // Liste der aktiven Sessions für das Admin-Panel
        $stmt = $db->query("SELECT session_id, MAX(timestamp) as last FROM messages GROUP BY session_id ORDER BY last DESC");
        $sessions = $stmt->fetchAll(PDO::FETCH_ASSOC);
        header('Content-Type: application/json');
        echo json_encode($sessions);
        break;

    case 'status':
    $statusFile = __DIR__ . '/admin_status.txt';
    $status = file_exists($statusFile) ? trim(file_get_contents($statusFile)) : 'offline';
    echo $status;
    break;
}
