<?php
if (isset($_GET['debug'])) {
  include '../config.php';
  echo "<pre>";
  echo "Anzahl Inhalte: " . count($db->query("SELECT * FROM contents")->fetchAll(PDO::FETCH_ASSOC));
  exit;
}
include '../config.php';
if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

// --- Speichern / Aktualisieren ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    $id = trim($_POST['id']);
    $content = $_POST['content'];

    $stmt = $db->prepare("INSERT OR REPLACE INTO contents (id, content) VALUES (?, ?)");
    $stmt->execute([$id, $content]);
    $message = "Inhalt gespeichert.";
}

// --- Löschen ---
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $db->prepare("DELETE FROM contents WHERE id = ?");
    $stmt->execute([$id]);
    $message = "Inhalt '$id' gelöscht.";
}

// --- Laden ---
$rows = $db->query("SELECT * FROM contents ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);

// --- Gruppenbildung nach Präfix ---
$groups = [];
foreach ($rows as $r) {
    if (preg_match('/^([a-zA-Z0-9_-]+?)[0-9_]*$/', $r['id'], $m)) {
        $prefix = strtolower($m[1]);
    } else {
        $prefix = 'Sonstiges';
    }
    $groups[$prefix][] = $r;
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
<title>CMS Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="tinymce/tinymce.min.js"></script>

<script>
tinymce.init({
  selector: 'textarea#content',
  height: 600,
  menubar: true,
  promotion: false, // entfernt den "Get all features" / Upgrade-Button in der Menüleiste
  branding: false, // blendet "Powered by Tiny" im Statusbalken aus

  // + Vorschau-Plugin (preview) ergänzt
  // (Media & Table hattest du schon – ich lasse sie drin)
  plugins: 'link image code lists emoticons textcolor media table preview', // + preview

  // + Vorschau-Button in die Toolbar aufgenommen
  //   Galerie-Button weiterhin auskommentiert (nicht gelöscht)
  toolbar: [
    'undo redo | fontfamily | styleselect fontselect | fontsizeinput | fontsizeselect bold italic underline | emoticons',
    'alignleft aligncenter alignright | bullist numlist | forecolor backcolor | link image media table | preview | code | bordercolorbutton', // + preview
    // 'gallerybutton', // (ausgeblendet, aber weiterhin registriert)
  ].join(' '),

  language: 'de',
  relative_urls: false,
  remove_script_host: false,

  automatic_uploads: true,
  images_upload_url: 'upload_image.php',
  file_picker_types: 'image',
  images_upload_credentials: true,

  image_advtab: true,
  valid_elements: '*[*]',
  // + iframes für Media-Einbettungen (YouTube/Vimeo etc.) zugelassen
  extended_valid_elements:
    'img[class|src|alt|title|width|height|style|data-*],a[href|target|title|class|style],div[class|style],span[class|style],iframe[src|frameborder|allowfullscreen|width|height|style]', // + iframe

  // + Live-Preview von eingebetteten Medien aktivieren
  media_live_embeds: true, // + neu

  // (Optional) Wenn die Vorschau so aussehen soll wie deine Website,
  // kannst du deine Frontend-CSS einbinden:
  // content_css: ['/css/site.css'], // + optional

  // + Mehrfach-Upload für Bilder:
  //   - Datei-Dialog erlaubt mehrere Bilder (input.multiple = true)
  //   - Alle Bilder werden hochgeladen und nacheinander im Editor eingefügt
  //   Hinweis: Der Image-Dialog hat nur ein Quellenfeld; bei Mehrfachauswahl fügen wir direkt in den Editor ein.
  file_picker_callback: function (cb, value, meta) {
    if (meta.filetype === 'image') {
      var input = document.createElement('input');
      input.type = 'file';
      input.accept = 'image/*';
      input.multiple = true; // + Mehrfachauswahl erlauben
      input.onchange = function () {
        var files = Array.from(this.files || []);
        if (!files.length) return;

        // Hilfsfunktion: einzelnes Bild hochladen -> URL zurückgeben
        var uploadOne = function (file) {
          var formData = new FormData();
          formData.append('file', file);
          return fetch('upload_image.php', { method: 'POST', body: formData, credentials: 'include' }) // + Credentials mitgeben wie oben konfiguriert
            .then(function (r) { return r.json(); })
            .then(function (data) {
              if (!data || !data.location) throw new Error('Antwort ohne URL');
              return data.location;
            });
        };

        // Alle Dateien hochladen
        Promise.all(files.map(uploadOne))
          .then(function (urls) {
            if (urls.length === 1) {
              // Standardverhalten für Einzelbild beibehalten
              cb(urls[0]); // setzt die Quelle im Image-Dialog
            } else {
              // Bei Mehrfachauswahl direkt Inhalte einfügen
              var ed = tinymce.activeEditor; // + aktuelle Editorinstanz
              urls.forEach(function (u) {
                ed.insertContent('<p><img src="' + u + '" alt="" /></p>'); // + jedes Bild separat einfügen
              });
              // Optional: Dialog schließen (falls geöffnet)
              // tinymce.activeEditor.windowManager.close(); // nur aktivieren, wenn gewünscht
            }
          })
          .catch(function (err) {
            alert('Upload-Fehler: ' + err);
          });
      };
      input.click();
    }
  },

  content_style: `
    img { max-width: 100%; height: auto; border-radius: 6px; }
    .left { float: left; margin: 0 10px 10px 0; }
    .right { float: right; margin: 0 0 10px 10px; }
    .center { display: block; margin: 0 auto 10px auto; }
    .shadow { box-shadow: 0 2px 8px rgba(0,0,0,0.3); }
    .rounded { border-radius: 10px; }
    .image-row { display: flex; flex-wrap: wrap; justify-content: center; }
    .image-row img { width: 100%; height: auto; border-radius: 6px; }
  `,

  style_formats: [
    { title: 'Bild links', selector: 'img', classes: 'left' },
    { title: 'Bild rechts', selector: 'img', classes: 'right' },
    { title: 'Bild zentriert', selector: 'img', classes: 'center' },
    { title: 'Abgerundet', selector: 'img', classes: 'rounded' },
    { title: 'Schatten', selector: 'img', classes: 'shadow' }
  ],

  setup: function (editor) {
    // Galerie-Button bleibt registriert, ist aber in der Toolbar auskommentiert
    editor.ui.registry.addButton('gallerybutton', {
      text: '📷 Galerie',
      tooltip: 'Mehrere Bilder nebeneinander anordnen',
      onAction: function () {
        const selected = editor.selection.getContent({ format: 'html' });
        if (!selected || !selected.includes('<img')) {
          alert('Bitte wähle mehrere Bilder aus oder füge sie zuerst ein.');
          return;
        }
        const columns = prompt('Wie viele Spalten möchtest du? (z. B. 2, 3, 4)', '3');
        const gap = prompt('Welchen Abstand zwischen den Bildern (in Pixel)?', '10');
        if (!columns || isNaN(columns)) return alert('Ungültige Spaltenzahl!');
        if (!gap || isNaN(gap)) return alert('Ungültiger Abstand!');
        const wrapped = `
          <div class="image-row" style="gap:${gap}px;">
            ${selected}
          </div>
          <style>
            .image-row a, .image-row img {
              flex: 1 1 calc(${100 / columns}% - ${gap}px);
              max-width: calc(${100 / columns}% - ${gap}px);
            }
            @media(max-width:768px){
              .image-row a, .image-row img { flex-basis: calc(50% - ${gap}px); max-width: calc(50% - ${gap}px); }
            }
            @media(max-width:480px){
              .image-row a, .image-row img { flex-basis: 100%; max-width: 100%; }
            }
          </style><p></p>`;
        editor.selection.setContent(wrapped);
      }
    });

    // Farbbutton
    editor.ui.registry.addButton('bordercolorbutton', {
      text: '🎨 Rahmenfarbe',
      tooltip: 'Rahmenfarbe für ausgewähltes Bild setzen',
      onAction: function () {
        const node = editor.selection.getNode();
        if (node.nodeName !== 'IMG') {
          alert('Bitte zuerst ein Bild auswählen.');
          return;
        }
        const picker = document.createElement('input');
        picker.type = 'color';
        picker.style.position = 'fixed';
        picker.style.zIndex = 99999;
        picker.style.left = '50%';
        picker.style.top = '50%';
        picker.style.transform = 'translate(-50%, -50%)';
        picker.style.width = '100px';
        picker.style.height = '60px';
        document.body.appendChild(picker);
        picker.addEventListener('input', function () {
          const color = this.value;
          let currentStyle = node.getAttribute('style') || '';
          currentStyle = currentStyle.replace(/border:[^;]+;?/gi, '');
          node.setAttribute('style', currentStyle + `border: 4px solid ${color};`);
        });
        picker.addEventListener('blur', function () { document.body.removeChild(picker); });
        picker.focus();
      }
    });
  }
});
</script>




</head>

<body class="bg-light">
<div class="container mt-4 mb-5">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Inhalte verwalten</h2>
    <div>
      <a href="admin_change.php" class="btn btn-outline-secondary btn-sm me-2">🔐 Admin ändern</a>
      <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
    </div>
  </div>

  <?php if (!empty($message)): ?>
    <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <?php
  $edit_id = $_GET['edit'] ?? '';
  $edit_content = '';
  if ($edit_id) {
      $stmt = $db->prepare("SELECT content FROM contents WHERE id = ?");
      $stmt->execute([$edit_id]);
      $edit_content = $stmt->fetchColumn() ?: '';
  }
  ?>

  <div class="card mb-4 p-3 shadow-sm">
    <form method="post">
      <div class="mb-3">
        <label class="form-label">Inhalt-ID</label>
        <input type="text" name="id" class="form-control" required value="<?= htmlspecialchars($edit_id) ?>">
      </div>
      <div class="mb-3">
        <label class="form-label">Inhalt (HTML erlaubt)</label>
        <textarea id="content" name="content" class="form-control" rows="10"><?= htmlspecialchars($edit_content) ?></textarea>
      </div>
      <button type="submit" name="save" class="btn btn-primary">💾 Speichern</button>
      <?php if ($edit_id): ?>
        <a href="dashboard.php" class="btn btn-secondary">Abbrechen</a>
      <?php endif; ?>
    </form>
  </div>

  <h4 class="mt-4">Vorhandene Inhalte</h4>

  <!-- Tabs -->
  <ul class="nav nav-tabs" id="cmsTabs" role="tablist">
    <?php $i=0; foreach ($groups as $group => $entries): ?>
      <li class="nav-item" role="presentation">
        <button class="nav-link <?= $i===0?'active':'' ?>" id="tab-<?= $group ?>" data-bs-toggle="tab"
          data-bs-target="#content-<?= $group ?>" type="button" role="tab">
          <?= ucfirst($group) ?> <span class="badge bg-secondary"><?= count($entries) ?></span>
        </button>
      </li>
    <?php $i++; endforeach; ?>
  </ul>

  <div class="tab-content border border-top-0 p-3 bg-white shadow-sm" id="cmsTabContent">
    <?php $i=0; foreach ($groups as $group => $entries): ?>
      <div class="tab-pane fade <?= $i===0?'show active':'' ?>" id="content-<?= $group ?>" role="tabpanel">
        <table class="table table-hover align-middle table-bordered">
          <thead class="table-light">
            <tr>
              <th style="width:15%;">ID</th>
              <th>Vorschau</th>
              <th style="width:130px;" class="text-center">Aktionen</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($entries as $r): ?>
              <tr>
                <td><span class="badge bg-primary text-uppercase px-3 py-2"><?= htmlspecialchars($r['id']) ?></span></td>
                <td><?= mb_strimwidth(strip_tags($r['content']), 0, 80, '…') ?></td>
                <td class="text-center">
                  <a href="dashboard.php?edit=<?= urlencode($r['id']) ?>" class="btn btn-warning btn-sm" title="Bearbeiten">✏️</a>
                  <a href="dashboard.php?delete=<?= urlencode($r['id']) ?>" class="btn btn-danger btn-sm ms-1"
                    onclick="return confirm('Diesen Eintrag wirklich löschen?')">🗑️</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php $i++; endforeach; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
