<?php
file_put_contents(__DIR__ . '/upload_debug.txt', print_r($_FILES, true));
// Bild-Upload für TinyMCE
$targetDir = __DIR__ . '/../uploads/';
if (!file_exists($targetDir)) {
    mkdir($targetDir, 0775, true);
}

if (!empty($_FILES['file']['name'])) {
    $fileName = basename($_FILES['file']['name']);
    $fileName = preg_replace('/[^A-Za-z0-9_\-.]/', '_', $fileName); // sicherer Dateiname
    $targetFile = $targetDir . $fileName;

    // Nur erlaubte Dateitypen
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if (in_array($ext, $allowed)) {
        if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
            // Erfolg → URL zurückgeben
            $url = '../uploads/' . $fileName;
            echo json_encode(['location' => $url]);
            exit;
        }
    }
}

http_response_code(400);
echo json_encode(['error' => 'Upload fehlgeschlagen']);
