<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/helpers.php';
require_admin();

header('Content-Type: application/json; charset=utf-8');

try {
  ensure_upload_dir();

  if (empty($_FILES['file'])) throw new Exception('Keine Datei');
  $f = $_FILES['file'];
  if ($f['error'] !== UPLOAD_ERR_OK) throw new Exception('Upload-Fehler');

  $max = MAX_UPLOAD_MB * 1024 * 1024;
  if ($f['size'] > $max) throw new Exception('Datei zu groß');

  $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
  $allowed = ['jpg','jpeg','png','gif','webp'];
  if (!in_array($ext, $allowed, true)) throw new Exception('Format nicht erlaubt');

  $name = 'img_' . date('Ymd_His') . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
  $target = UPLOAD_DIR . $name;

  if (!move_uploaded_file($f['tmp_name'], $target)) throw new Exception('Speichern fehlgeschlagen');

  // ABSOLUT (für Tiny Dimensionen wichtig!)
  $url = base_url(ltrim(UPLOAD_URL, '/') . $name);

  echo json_encode(['location' => $url], JSON_UNESCAPED_SLASHES);
  exit;

} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['error' => $e->getMessage()]);
}
