<?php
declare(strict_types=1);

require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';

$pdo = db();

$rows = $pdo->query("
  SELECT
    strftime('%Y', published_at, 'unixepoch') AS year,
    strftime('%m', published_at, 'unixepoch') AS month,
    COUNT(*) AS cnt
  FROM posts
  WHERE status = 'published'
  GROUP BY year, month
  ORDER BY year DESC, month DESC
")->fetchAll();

$currentYear = '';

echo '<div class="mobiblog-archive">';
echo '<h5>Archiv</h5>';
echo '<ul class="list-unstyled">';

foreach ($rows as $r) {

    if ($currentYear !== $r['year']) {
        if ($currentYear !== '') {
            echo '</ul></li>';
        }
        echo '<li class="fw-bold mt-3">' . e($r['year']) . '<ul>';
        $currentYear = $r['year'];
    }

    $monat = monat_de((int)$r['month']);

    echo '<li>
      <a href="?year=' . e($r['year']) . '&month=' . (int)$r['month'] . '">
        ' . $monat . '
        (' . (int)$r['cnt'] . ')
      </a>
    </li>';
}

if ($currentYear !== '') {
    echo '</ul></li>';
}

echo '</ul>';
echo '</div>';
