<?php
// Basis-Konfig (hart), lokale Werte kommen aus config.local.php
declare(strict_types=1);
/* ✅ WICHTIG: Zeitzone fest setzen */
date_default_timezone_set('Europe/Berlin');

define('APP_NAME', 'Mobiblog');
define('APP_ROOT', realpath(__DIR__ . '/..') . DIRECTORY_SEPARATOR);

// URL-Pfad, unter dem mobiblog im Web hängt
// Beispiel: https://domain.de/mobiblog/  => BASE_PATH = '/mobiblog/'
define('BASE_PATH', '/mobiblog/');

define('MAX_UPLOAD_MB', 10);

// Uploads
define('UPLOAD_DIR', APP_ROOT . 'uploads/posts' . DIRECTORY_SEPARATOR);
define('UPLOAD_URL', BASE_PATH . 'uploads/posts/'); // öffentlich erreichbare URL

// Session
define('SESSION_NAME', 'mobiblog_admin');

// Lokale Config laden (Installer erzeugt die Datei)
$local = __DIR__ . '/config.local.php';
if (is_file($local)) require $local;
