<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';

$limit = (int)($_GET['limit'] ?? 5);
$limit = max(1, min(20, $limit));

$pdo = db();
$st = $pdo->prepare("SELECT title, slug, published_at FROM posts
                     WHERE status='published'
                     ORDER BY published_at DESC
                     LIMIT ?");
$st->bindValue(1, $limit, PDO::PARAM_INT);
$st->execute();
$posts = $st->fetchAll();

foreach ($posts as $p) {
  echo '<div class="mb-3">';
  echo '<div><a href="'.e(BASE_PATH).'post.php?slug='.e($p['slug']).'">'.e($p['title']).'</a></div>';
  echo '<small class="text-muted">'.date('d.m.Y', (int)$p['published_at']).'</small>';
  echo '</div>';
}
