<?php
declare(strict_types=1);
require_once __DIR__ . '/inc/config.php';
require_once __DIR__ . '/inc/db.php';
require_once __DIR__ . '/inc/helpers.php';

$slug = trim($_GET['slug'] ?? '');
$pdo = db();
$st = $pdo->prepare("SELECT * FROM posts WHERE slug=? AND status='published' LIMIT 1");
$st->execute([$slug]);
$p = $st->fetch();
if (!$p) { http_response_code(404); echo "Nicht gefunden"; exit; }
?>
<!doctype html>
<html lang="de"><head><meta charset="utf-8"><title><?= e($p['title']) ?></title></head>
<body style="font-family:Arial; padding:20px">
<p><a href="<?= e(BASE_PATH) ?>index.php">← zurück</a></p>
<h1><?= e($p['title']) ?></h1>
<div style="color:#666"><?= date('d.m.Y', (int)$p['published_at']) ?></div>
<hr>
<div><?= $p['content'] /* HTML aus Tiny */ ?></div>
</body></html>
