<?php
// upload_image.php
if (!empty($_FILES['file']['name'])) {
    $uploadDir = '../uploads/';
    $filename = uniqid('news_') . '_' . basename($_FILES['file']['name']);
    $targetFile = $uploadDir . $filename;

    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    if (!in_array($extension, $allowed)) {
        http_response_code(400);
        echo json_encode(['error' => 'Ungültiges Dateiformat.']);
        exit;
    }

    if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
        // Rückgabe: JSON mit Bild-URL
        echo json_encode(['location' => 'uploads/' . $filename]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Upload fehlgeschlagen.']);
    }
}
?>
