<?php
session_start();
if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

require_once '../config.php';

// Hintergrundfarbe laden
//$stmtBg = $conn->query("SELECT body_hintergrund FROM settings WHERE id=1");
//$bgSettings = $stmtBg->fetch(PDO::FETCH_ASSOC);
//$bodyBgColor = $bgSettings['body_hintergrund'] ?? '#f8f9fa';

// News laden
$stmt = $conn->query("SELECT * FROM news ORDER BY datum DESC");
$newsList = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="background-color: <?= htmlspecialchars($bodyBgColor) ?>;">
<div class="container mt-4">
    <h2>Dashboard</h2>
    <div class="mb-3">
        <a href="settings.php" class="btn btn-outline-primary btn-sm">⚙️ Einstellungen</a>
        <a href="logout.php" class="btn btn-outline-danger btn-sm">🚪 Abmelden</a>
        <a href="../news.php" class="btn btn-warning btn-sm" target="_blank">News Seite öffnen</a>
    </div>
    <a href="admin.php" class="btn btn-success mb-3">➕ Neuigkeiten hinzufügen</a>
    <a href="bilder_loeschen.php" class="btn btn-success mb-3">- Nicht benötigte Bilder löschen</a>

    <?php if (count($newsList) > 0): ?>
        <table class="table table-bordered table-striped bg-white">
            <thead>
                <tr>
                    <th>Titel</th>
                    <th>Date</th>
                    <th>Bild</th>
                    <th>Zusammenfassung</th>
                    <th>Aktionen</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($newsList as $n): ?>
                    <tr>
                        <td><?= htmlspecialchars($n["titel"]) ?></td>
                        <td><?= date('d.m.Y', strtotime($n["datum"])) ?></td>
                        <?php
                        $imgPath = __DIR__ . "/../uploads/" . $n["bild"];
                        $imgUrl = "../uploads/" . $n["bild"];
                        ?>
                        <?php if (!empty($n["bild"]) && file_exists($imgPath)): ?>
                            <td><img src="<?= htmlspecialchars($imgUrl) ?>" alt="img" width="80" class="img-thumbnail"></td>
                        <?php else: ?>
                            <td><span class="text-muted">Keine Bilder</span></td>
                        <?php endif; ?>
                        <td><?= strip_tags($n["text"], '<p><br><b><strong><em>') ?></td>
                        <td>
                            <a href="modifier.php?id=<?= $n["id"] ?>" class="btn btn-sm btn-primary" style="width: 100px;">Bearbeiten</a><br><br>
                            <a href="supprimer.php?id=<?= $n["id"] ?>" class="btn btn-sm btn-danger" style="width: 100px;" onclick="return confirm('Confirmer la suppression ?')">Löschen</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="alert alert-info">Keine Neuigkeiten gefunden.</div>
    <?php endif; ?>
</div>
</body>
</html>
