<?php
session_start();

// Alle Session-Variablen löschen
$_SESSION = [];

// Falls ein Session-Cookie existiert, löschen
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Session vollständig zerstören
session_destroy();

// Weiterleitung zur Login-Seite
header("Location: index.php");
exit;
?>
