<?php
session_start();
require_once '../config.php';

if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

$id = $_GET["id"] ?? null;

if ($id) {
    // Bildpfad ermitteln
    $stmt = $conn->prepare("SELECT bild FROM news WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && !empty($row['bild'])) {
        $bildPath = __DIR__ . '/../uploads/' . $row['bild'];
        if (file_exists($bildPath)) {
            unlink($bildPath);
        }
    }

    // News-Eintrag löschen
    $stmt = $conn->prepare("DELETE FROM news WHERE id = ?");
    $stmt->execute([$id]);
}

header("Location: dashboard.php");
exit;
