<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (file_exists(__DIR__ . '/../config.php')) {
    die("<div class='alert alert-danger m-5'>Die Installation ist bereits abgeschlossen. Löschen Sie den Ordner <code>install</code>.</div>");
}

$error = '';
$warning = '';
$hasTables = false;

function hasExistingTables($conn, $db) {
    $result = $conn->query("SHOW TABLES FROM `$db`");
    return ($result && $result->num_rows > 0);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['step']) && $_GET['step'] === 'confirm' && isset($_SESSION['install_data'])) {
    $_POST['confirm'] = 'yes';
    $_SERVER['REQUEST_METHOD'] = 'POST';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['confirm']) && $_POST['confirm'] === 'no') {
        echo "<div class='alert alert-warning m-5'>Installation abgebrochen.</div>";
        session_destroy();
        exit;
    }

    if (isset($_POST['confirm']) && $_POST['confirm'] === 'yes' && isset($_SESSION['install_data'])) {
        extract($_SESSION['install_data']);
        $conn = new mysqli($host, $user, $pass);
        if ($conn->connect_error) {
            $error = "Verbindungsfehler : " . $conn->connect_error;
        } else {
            if (!$conn->query("CREATE DATABASE IF NOT EXISTS `$name` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci")) {
                $error = "Fehler beim Erstellen der Datenbank : " . $conn->error;
            } else {
                $conn->select_db($name);
            }
        }

        if (!$error) {
            $configPath = __DIR__ . '/../config.php';
            if (!is_writable(dirname($configPath))) {
                $error = "Fehler: Der übergeordnete Ordner ist nicht beschreibbar.";
            } else {
        $configContent = "<?php\n";
        $configContent .= "session_start();\n";
        $configContent .= "\$host = '" . addslashes($host) . "';\n";
        $configContent .= "\$db = '" . addslashes($name) . "';\n";
        $configContent .= "\$user = '" . addslashes($user) . "';\n";
        $configContent .= "\$pass = '" . addslashes($pass) . "';\n";
        $configContent .= "try {\n";
        $configContent .= "    \$conn = new PDO(\"mysql:host=\$host;dbname=\$db;charset=utf8mb4\", \$user, \$pass);\n";
        $configContent .= "    \$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);\n";
        $configContent .= "} catch (PDOException \$e) {\n";
        $configContent .= "    die(\"Verbindungsfehler : \" . \$e->getMessage());\n";
        $configContent .= "}\n";
        $configContent .= "?>";

                if (file_put_contents($configPath, $configContent)) {
                    $sqlFile = __DIR__ . '/schema.sql';
                    if (file_exists($sqlFile)) {
                        $sql = file_get_contents($sqlFile);
                        if ($sql) {
                            if ($conn->multi_query($sql)) {
                                do {
                                    if ($result = $conn->store_result()) {
                                        $result->free();
                                    }
                                } while ($conn->more_results() && $conn->next_result());
                                if ($conn->errno) {
                                    $error = "SQL-Fehler während der Installation : " . $conn->error;
                                }
                            } else {
                                $error = "Fehler beim Ausführen der SQL-Datei : " . $conn->error;
                            }
                        } else {
                            $error = "Die Datei schema.sql ist leer oder nicht lesbar.";
                        }
                    }

                    // 🔒 Ajout admin
                    $hashedPass = password_hash($admin_pass, PASSWORD_BCRYPT);
                    $stmt = $conn->prepare("INSERT INTO admins (benutzername, passwort) VALUES (?, ?)");
                    if ($stmt) {
                        $stmt->bind_param("ss", $admin_user, $hashedPass);
                        $stmt->execute();
                        $stmt->close();
                    } else {
                        $error = "Fehler beim Erstellen des Administrators: " . $conn->error;
                    }

                    // ✅ Mise à jour ou insertion reCAPTCHA
                    // Supprime la ligne existante pour éviter les conflits
                    $conn->query("DELETE FROM settings WHERE id=1");

                    $stmt2 = $conn->prepare("INSERT INTO settings (id, recaptcha_active, recaptcha_sitekey, recaptcha_secretkey) VALUES (1, ?, ?, ?)");
                    if ($stmt2) {
                        $stmt2->bind_param("iss", $use_recaptcha, $recaptcha_sitekey, $recaptcha_secretkey);
                        $stmt2->execute();
                        $stmt2->close();
                    } else {
                        $error = "Fehler beim Einfügen von reCAPTCHA-Schlüsseln : " . $conn->error;
                    }


                    // 🧹 Suppression install
                    if (!$error && is_writable(__DIR__)) {
function rrmdir($dir) {
    if (!is_dir($dir)) return;

    $items = scandir($dir);
    foreach ($items as $item) {
        if ($item == '.' || $item == '..') continue;

        $path = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($path)) {
            rrmdir($path);
        } else {
            @unlink($path);
        }
    }
    @rmdir($dir);
}

                        rrmdir(__DIR__);
                        session_destroy();


                        echo <<<HTML
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Installation abgeschlossen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="alert alert-success p-4">
        <h3 class="mb-3">✅ Installation erfolgreich</h3>
        <p>config.php wurde erstellt und die Datenbank initialisiert.</p>
        <p><strong>Admin-Login :</strong> $admin_user</p>
        <p><strong>reCAPTCHA :</strong> " . ($use_recaptcha ? 'Activé' : 'Désactivé') . "</p>
        <hr>
        <h5>Intégration iframe :</h5>
        <pre>&lt;iframe src="news.php" width="100%" height="600" style="border:0;"&gt;&lt;/iframe&gt;</pre>
        <a href="../news.php" class="btn btn-primary mt-3">➡️ Nachrichten anzeigen</a>
        <a href="../admin/index.php" class="btn btn-secondary mt-3">🔐 Admin Login</a>
    </div>
</div>
</body>
</html>
HTML;
                        exit;
                    } else {
                        $warning = "Le dossier install n'a pas pu être supprimé automatiquement.";
                    }
                } else {
                    $error = "Fehler beim Erstellen der Datei config.php.";
                }
            }
        }
    } else {
        $host = trim($_POST['db_host']);
        $user = trim($_POST['db_user']);
        $pass = trim($_POST['db_pass']);
        $name = trim($_POST['db_name']);
        $admin_user = trim($_POST['admin_user'] ?? '');
        $admin_pass = $_POST['admin_pass'] ?? '';
        $use_recaptcha = isset($_POST['use_recaptcha']) ? 1 : 0;
        $recaptcha_sitekey = $_POST['recaptcha_sitekey'] ?? '';
        $recaptcha_secretkey = $_POST['recaptcha_secretkey'] ?? '';

        $_SESSION['install_data'] = compact('host', 'user', 'pass', 'name', 'admin_user', 'admin_pass', 'use_recaptcha', 'recaptcha_sitekey', 'recaptcha_secretkey');

        $conn = @new mysqli($host, $user, $pass);
        if ($conn->connect_error) {
            $error = "Verbindung fehlgeschlagen : " . $conn->connect_error;
        } else {
            if (!$conn->query("CREATE DATABASE IF NOT EXISTS `$name` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci")) {
                $error = "Fehler beim Erstellen der Datenbank : " . $conn->error;
            } else {
                $conn->select_db($name);
                if (hasExistingTables($conn, $name)) {
                    $hasTables = true;
                } else {
                    header("Location: install.php?step=confirm");
                    exit;
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Installation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-body">
            <h2 class="card-title mb-4">🛠 System Installation</h2>

            <?php if ($error): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>

            <?php if ($warning): ?>
                <div class="alert alert-warning"><?= $warning ?></div>
            <?php endif; ?>

            <?php if ($hasTables): ?>
                <div class="alert alert-warning">
                    ⚠️ Die Datenbank enthält bereits Tabellen. Fortfahren kann Daten überschreiben.
                </div>
                <form method="post" class="d-flex gap-2">
                    <input type="hidden" name="confirm" value="yes">
                    <button type="submit" class="btn btn-success">✅ Fortfahren</button>
                </form>
                <form method="post" class="mt-2">
                    <input type="hidden" name="confirm" value="no">
                    <button type="submit" class="btn btn-secondary">❌ Abbrechen</button>
                </form>
            <?php else: ?>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label"> Host</label>
                        <input type="text" name="db_host" class="form-control" value="localhost" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Datenbank Benutzer</label>
                        <input type="text" name="db_user" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Datenbank Passwort</label>
                        <input type="password" name="db_pass" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Datenbankname</label>
                        <input type="text" name="db_name" class="form-control" required>
                    </div>
                    <hr>
                    <h5>👤 Administratorkonto</h5>
                    <div class="mb-3">
                        <label class="form-label">Login</label>
                        <input type="text" name="admin_user" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Passwort</label>
                        <input type="password" name="admin_pass" class="form-control" required>
                    </div>
                    <hr>
                    <h5>🔐 reCAPTCHA (optional)</h5>
                    <div class="form-check mb-2">
                        <input type="checkbox" name="use_recaptcha" class="form-check-input" id="useRecaptcha">
                        <label for="useRecaptcha" class="form-check-label">Google reCAPTCHA v2 aktivieren</label>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Site Key</label>
                        <input type="text" name="recaptcha_sitekey" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Secret Key</label>
                        <input type="text" name="recaptcha_secretkey" class="form-control">
                    </div>
                    <button type="submit" class="btn btn-primary">🚀 Installieren</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>
</body>
</html>


