<?php
// Autor: Volker Niederastroth 2025
require_once 'config.php';
$db = db_connect();

$meldung = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $stmt = $db->prepare("INSERT INTO downloads (email, erstellt_am) VALUES (?, datetime('now'))");
        $stmt->execute([$email]);
        $meldung = "✅ Vielen Dank! Wir prüfen deinen Zahlungseingang und schalten dich dann frei. 
                    Du erhältst den Download-Link per E-Mail, sobald deine Spende bestätigt wurde.";
    } else {
        $meldung = "❌ Bitte gib eine gültige E-Mail-Adresse an.";
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Spende & Download</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background-color: #000; /* schwarzer Hintergrund */
    color: #fff;
    font-family: system-ui, sans-serif;
}
.card {
    background: #fff;
    color: #000;
    box-shadow: 0 6px 18px rgba(255,255,255,0.1);
    border-radius: 12px;
}
.btn-paypal {
    background-color: #ffc439;
    color: #111;
    font-weight: 600;
}
.btn-paypal:hover {
    background-color: #ffb347;
    color: #111;
}
label, .form-label {
    color: #000; /* Labels bleiben schwarz auf weißer Karte */
}
.alert-info {
    background-color: #e9f5ff;
    color: #000;
    border: 1px solid #b6d4fe;
}
</style>
</head>
<body>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-7">
            <div class="card p-4">
                <div class="card-body text-center">
                    <h2 class="mb-3">🎁 Supermailer Download</h2>
                    <p class="text-muted">
                        Bitte sende eine kleine Spende von <strong>10 €</strong> über PayPal (Freunde & Familie) an:
                    </p>
                    <a href="<?= PAYPAL_LINK ?>" target="_blank" class="btn btn-paypal mb-3">
                        💳 Volker Niederastroth
                    </a>
                    <p class="text-secondary small mb-4">
                        Nach der Spende trage bitte unten deine E-Mail-Adresse ein,
                        damit ich dir den Download-Link zusenden kann.
                    </p>

                    <form method="post" class="text-start">
                        <div class="mb-3">
                            <label for="email" class="form-label">Deine E-Mail-Adresse <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" name="email" id="email" required>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">Ich habe gespendet</button>
                        </div>
                    </form>

                    <?php if ($meldung): ?>
                        <div class="alert alert-info mt-4">
                            <?= htmlspecialchars($meldung) ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
