<?php
// Autor: Volker Niederastroth 2025
require_once 'config.php';
session_start();

if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// ---------------------
// LOGIN
// ---------------------
if (!isset($_SESSION['admin'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['passwort'] ?? '') === ADMIN_PASSWORT) {
        $_SESSION['admin'] = true;
        header("Location: admin.php");
        exit;
    }
    ?>
    <form method="post" style="max-width:300px;margin:80px auto;font-family:sans-serif;">
        <h3>Admin-Login</h3>
        <input type="password" name="passwort" placeholder="Passwort" required style="width:100%;padding:8px;">
        <button type="submit" style="margin-top:10px;padding:8px 12px;">Login</button>
    </form>
    <?php
    exit;
}

$db = db_connect();

// ---------------------
// POST-AKTIONEN
// ---------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // 1) Löschen
    if ($action === 'delete' && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        $stmt = $db->prepare("DELETE FROM downloads WHERE id=?");
        $stmt->execute([$id]);

        header("Location: admin.php");
        exit;
    }

    // 2) Freischalten + E-Mail
    if ($action === 'unlock' && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        $dateiname = trim($_POST['dateiname'] ?? '');

        if ($dateiname !== '') {
            // Datensatz laden (für Empfängeradresse)
            $stmt = $db->prepare("SELECT * FROM downloads WHERE id=?");
            $stmt->execute([$id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($row) {
                $token = bin2hex(random_bytes(16));

                // Update + Ablaufzeit
                $stmt = $db->prepare("UPDATE downloads 
                    SET token=?, dateiname=?, erstellt_am=datetime('now'),
                        abgelaufen_am=datetime('now', '+' || ? || ' hours')
                    WHERE id=?");
                $stmt->execute([$token, $dateiname, LINK_GUELTIGKEIT_STUNDEN, $id]);

                // Zur Sicherheit: frisch lesen und prüfen, ob Token wirklich gesetzt ist
                $stmt = $db->prepare("SELECT email, token FROM downloads WHERE id=?");
                $stmt->execute([$id]);
                $after = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($after && !empty($after['token']) && filter_var($row['email'], FILTER_VALIDATE_EMAIL)) {
                    // Download-Link bauen
                    $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
                    $basePath = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
                    $downloadLink = $proto . $_SERVER['HTTP_HOST'] . $basePath . "/download.php?token=" . $after['token'];

                    // Mail versenden
                    $empfaenger = trim($row['email']);
                    $betreff = "Dein Download-Link";
                    $nachricht = "Hallo!\n\n"
                        . "vielen Dank für deine Unterstützung über PayPal.\n\n"
                        . "Hier ist dein Download-Link (gültig für " . LINK_GUELTIGKEIT_STUNDEN . " Stunden):\n"
                        . $downloadLink . "\n\n"
                        . "Viele Grüße\n"
                        . "Dein Team";//Namen hier ändern
                    $header = "From: noreply@" . $_SERVER['HTTP_HOST'] . "\r\n"
                            . "Content-Type: text/plain; charset=UTF-8";

                    @mail($empfaenger, $betreff, $nachricht, $header);
                }
            }
        }

        header("Location: admin.php");
        exit;
    }
}

// ---------------------
// LISTE LADEN
// ---------------------
$eintraege = $db->query("SELECT * FROM downloads ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Admin - Freischaltungen</title>
<style>
body { font-family: sans-serif; max-width: 1000px; margin: 40px auto; }
table { width: 100%; border-collapse: collapse; margin-top: 20px; }
th, td { border: 1px solid #ccc; padding: 6px 8px; vertical-align: top; }
input[type=text] { width: 100%; padding: 5px; }
button { padding: 5px 10px; cursor: pointer; }
form.inline { display:inline; }
em { color: #666; }
tr:nth-child(even) { background: #f9f9f9; }
.btn-danger { background:#e33;color:#fff;border:none;border-radius:4px; }
.btn-primary { background:#2b7bdc;color:#fff;border:none;border-radius:4px; }
</style>
</head>
<body>
<h2>Adminbereich</h2>
<form method="post" style="text-align:right;">
  <button name="logout">Logout</button>
</form>

<table>
<tr>
  <th>ID</th>
  <th>E-Mail</th>
  <th>Datei</th>
  <th>Token / Link</th>
  <th>Aktion</th>
</tr>
<?php foreach ($eintraege as $row): ?>
<tr>
  <td><?= (int)$row['id'] ?></td>
  <td><?= htmlspecialchars($row['email'] ?? '') ?></td>
  <td><?= htmlspecialchars($row['dateiname'] ?? '') ?></td>
  <td>
    <?php if (!empty($row['token'])): ?>
      <a href="download.php?token=<?= htmlspecialchars($row['token']) ?>" target="_blank">Download-Link</a><br>
      (gültig bis <?= htmlspecialchars($row['abgelaufen_am']) ?>)
    <?php else: ?>
      <em>noch nicht freigeschaltet</em>
    <?php endif; ?>
  </td>
  <td style="white-space: nowrap;">
    <?php if (empty($row['token'])): ?>
      <!-- Freischalten -->
      <form method="post" class="inline">
        <input type="hidden" name="action" value="unlock">
        <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">
        <input type="text" name="dateiname" placeholder="z. B. script_v1.7z" required>
        <button class="btn-primary">Freischalten</button>
      </form>
    <?php endif; ?>

    <!-- Löschen -->
    <form method="post" class="inline" onsubmit="return confirm('Diesen Eintrag wirklich löschen?');">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">
      <button class="btn-danger">Löschen</button>
    </form>
  </td>
</tr>
<?php endforeach; ?>
</table>
</body>
</html>
