<?php
require __DIR__.'/../auth.php';
if (!is_admin()) { header('Location: ../login.php'); exit; }

$dir = __DIR__.'/../uploads/';
$files = array_values(array_filter(scandir($dir), fn($f) =>
    preg_match('/\.(jpg|jpeg|png|gif|webp)$/i',$f)
));
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Media Manager</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
<div class="container py-4">

<h2>Media Manager</h2>
<a href="dashboard.php" class="btn btn-secondary mb-3">⬅ zurück</a>

<div class="row g-3">
<?php foreach ($files as $f): ?>
  <div class="col-6 col-md-3">
    <div class="card shadow-sm">
      <img src="../uploads/<?= htmlspecialchars($f) ?>" class="img-fluid">
      <div class="card-body text-center">
        <button class="btn btn-sm btn-danger"
          onclick="deleteImage('<?= htmlspecialchars($f) ?>',this)">
          🗑 löschen
        </button>
      </div>
    </div>
  </div>
<?php endforeach ?>
</div>

</div>

<script src="media.js"></script>
</body>
</html>
