if (typeof tinymce === 'undefined') {
  console.error('TinyMCE nicht geladen');
}

/* Inline Tiny initialisieren */
tinymce.init({
  ...window.TINY_FULL_CONFIG,

  selector: '.cms-content',
  inline: true,

  images_upload_url: CMS_BASE_URL + '/upload_image.php'
});

/* Speichern */
function saveCMS(slug) {
  const el = document.querySelector('.cms-content[data-slug="'+slug+'"]');
  if (!el) return alert('Block nicht gefunden');

  fetch(CMS_BASE_URL + '/save.php', {
    method: 'POST',
    headers: { 'Content-Type':'application/json' },
    body: JSON.stringify({
      slug: slug,
      content: el.innerHTML
    })
  })
  .then(r => r.text())
  .then(msg => alert(msg))
  .catch(err => alert('Fehler: ' + err));
}
