// tiny_config.js – VOLLAUSSTATTUNG (INLINE + DASHBOARD)

function initTinyInline(selector) {
  tinymce.init({
    selector: selector,
    inline: true,

    height: 600,
    menubar: true,
    promotion: false,
    branding: false,
    language: 'de',

    plugins: `
      advlist autolink lists link image emoticons
      media table code preview
      searchreplace visualblocks fullscreen
    `,

    toolbar: [
      'undo redo | fontfamily | styleselect fontselect | fontsizeinput fontsizeselect | bold italic underline | emoticons',
      'alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | forecolor backcolor',
      'link image media table | preview fullscreen | code | bordercolorbutton'
    ],

    relative_urls: false,
    remove_script_host: false,

    automatic_uploads: true,
    images_upload_url: window.CMS_UPLOAD_URL,
    images_upload_credentials: true,

    image_advtab: true,
    valid_elements: '*[*]',
    extended_valid_elements:
      'img[class|src|alt|title|width|height|style|data-*],' +
      'a[href|target|title|class|style],' +
      'div[class|style],' +
      'span[class|style],' +
      'iframe[src|frameborder|allowfullscreen|width|height|style]',

    media_live_embeds: true,

    content_style: `
      img { max-width:100%; height:auto; border-radius:6px; }
      .left { float:left; margin:0 10px 10px 0; }
      .right { float:right; margin:0 0 10px 10px; }
      .center { display:block; margin:0 auto 10px auto; }
      .shadow { box-shadow:0 2px 8px rgba(0,0,0,0.3); }
      .rounded { border-radius:10px; }
    `,

    setup: function (editor) {

      // 🎨 Rahmenfarbe-Button
      editor.ui.registry.addButton('bordercolorbutton', {
        text: '🎨 Rahmen',
        tooltip: 'Rahmenfarbe für Bild setzen',
        onAction: function () {
          const node = editor.selection.getNode();
          if (node.nodeName !== 'IMG') {
            alert('Bitte zuerst ein Bild auswählen.');
            return;
          }

          const picker = document.createElement('input');
          picker.type = 'color';
          picker.style.position = 'fixed';
          picker.style.zIndex = 99999;
          picker.style.left = '50%';
          picker.style.top = '50%';
          picker.style.transform = 'translate(-50%, -50%)';
          picker.style.width = '120px';
          picker.style.height = '60px';
          document.body.appendChild(picker);

          picker.addEventListener('input', function () {
            let style = node.getAttribute('style') || '';
            style = style.replace(/border:[^;]+;?/gi, '');
            node.setAttribute('style', style + 'border:4px solid ' + this.value + ';');
          });

          picker.addEventListener('blur', () => picker.remove());
          picker.focus();
        }
      });
    }
  });
}
