<?php
/**
 * cms.php – Inline CMS (FINAL & STABIL)
 * - Inline-Editing mit Tiny Vollausstattung
 * - KEINE Session-Logik im Frontend
 * - Sicherheit ausschließlich in save.php
 */

$config = require __DIR__ . '/config.php';

/* -------------------------------------------------
   Slug MUSS gesetzt sein
------------------------------------------------- */
if (!isset($slug) || trim($slug) === '') {
    echo '<!-- CMS: kein Slug gesetzt -->';
    return;
}

$slug = trim($slug);

/* -------------------------------------------------
   Inhalt aus DB laden
------------------------------------------------- */
try {
    $db = new PDO('sqlite:' . $config['DB']);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db->prepare("SELECT content FROM contents WHERE slug = ?");
    $stmt->execute([$slug]);
    $content = $stmt->fetchColumn();
} catch (Throwable $e) {
    echo '<!-- CMS DB Fehler -->';
    return;
}

/* -------------------------------------------------
   Content ausgeben
------------------------------------------------- */
echo '<div class="cms-content" data-slug="' . htmlspecialchars($slug) . '">';
echo ($content !== false) ? $content : '';
echo '</div>';

/* -------------------------------------------------
   Edit-Modus?
------------------------------------------------- */
if (!isset($_GET['edit']) || $_GET['edit'] != 1) {
    return;
}

/* -------------------------------------------------
   Tiny + Editor nur EINMAL laden
------------------------------------------------- */
static $editorLoaded = false;

if (!$editorLoaded) {
    $editorLoaded = true;

    // TinyMCE Core (absoluter Pfad)
    echo '<script src="' .
        htmlspecialchars(
            rtrim($config['BASE_URL'], '/') . '/' . ltrim($config['TINYMCE'], '/')
        ) .
    '"></script>';

    // Upload-URL global
    echo '<script>
        window.CMS_UPLOAD_URL = "' . htmlspecialchars($config['BASE_URL']) . '/upload_image.php";
        window.CMS_BASE_URL   = "' . htmlspecialchars($config['BASE_URL']) . '";
    </script>';

    // Tiny Voll-Konfiguration
    echo '<script src="' . htmlspecialchars($config['BASE_URL']) . '/tiny_config.js"></script>';

    // Tiny Inline initialisieren
    echo '<script>
        if (typeof initTinyInline === "function") {
            initTinyInline(".cms-content");
        } else {
            console.error("initTinyInline nicht gefunden");
        }
    </script>';

    // Save-Logik
    echo '<script src="' . htmlspecialchars($config['BASE_URL']) . '/editor.js"></script>';
}

/* -------------------------------------------------
   FIXED SPEICHER-BUTTON (ÜBER ALLEM!)
------------------------------------------------- */
echo '
<div class="cms-editor-toolbar"
     style="
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 999999; /* WICHTIG */
        background: #ffffff;
        border: 1px solid #ccc;
        padding: 10px 14px;
        border-radius: 6px;
        box-shadow: 0 4px 14px rgba(0,0,0,0.25);
     ">
    <button type="button"
        style="
            font-size:14px;
            padding:6px 12px;
            cursor:pointer;
        "
        onclick="saveCMS(\'' . htmlspecialchars($slug, ENT_QUOTES) . '\')">
        💾 Block speichern
    </button>
</div>';
