<?php
// save.php – ZENTRALER SAVE ENDPOINT

require __DIR__ . '/auth.php';

if (!is_admin()) {
    http_response_code(403);
    echo 'Keine Berechtigung';
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$slug = trim($data['slug'] ?? '');
$content = $data['content'] ?? '';

if ($slug === '') {
    http_response_code(400);
    echo 'Ungültiger Slug';
    exit;
}

try {
    $db = db();
    $stmt = $db->prepare(
        "INSERT INTO contents (slug, content)
         VALUES (?, ?)
         ON CONFLICT(slug) DO UPDATE SET content = excluded.content"
    );
    $stmt->execute([$slug, $content]);

    echo 'OK';
} catch (Throwable $e) {
    http_response_code(500);
    echo 'DB Fehler';
}
