<?php
/******************************************************************
 * GLOBAL SAFE SESSION + OUTPUT BUFFERING
 ******************************************************************/

// WICHTIG: Keine Leerzeichen oder BOM vor diesem <?php !!!

// Output buffering aktivieren – VERHINDERT Header-Fehler
if (!headers_sent()) {
    ob_start();
}

// Session nur im Admin starten
if (
    php_sapi_name() !== 'cli' &&               
    isset($_SERVER['REQUEST_URI']) &&
    strpos($_SERVER['REQUEST_URI'], '/suche/admin/') !== false
) {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
}

/******************************************************************
 * SQLITE DB
 ******************************************************************/
$db_file = __DIR__ . '/../search.db';

try {
    $pdo = new PDO('sqlite:' . $db_file);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Throwable $e) {
    die("Datenbankfehler: " . $e->getMessage());
}
