<?php
require 'config.php';

ini_set('display_errors',1);
error_reporting(E_ALL);

/*
    ======================================================
       1) ERMITTLE EXISTIERENDE TABELLEN
    ======================================================
*/
$stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table'");
$tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

/*
    ======================================================
       2) WENN USER NOCH NICHT ANGELEGT → ERSTINSTALLATION
    ======================================================
*/
if (!in_array('admin_users', $tables)) {

    // ----- ADMIN USERS -------------
    $pdo->exec("
        CREATE TABLE admin_users (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT NOT NULL,
            password TEXT NOT NULL
        )
    ");

    $hash = password_hash('admin', PASSWORD_DEFAULT);

    $pdo->prepare("
        INSERT INTO admin_users (username,password)
        VALUES ('admin', :pw)
    ")->execute([':pw' => $hash]);


    // ----- SEARCH SETTINGS ----------
    $pdo->exec("
        CREATE TABLE search_settings (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            result_mode TEXT DEFAULT 'inline',
            search_limit INTEGER DEFAULT 50,
            widget_css TEXT,
            pdf_path TEXT,
            excluded_folders TEXT,
            allowed_extensions TEXT,
            protected_patterns TEXT,
            updated_at TEXT
        )
    ");

    $pdo->prepare("
        INSERT INTO search_settings (
            result_mode,
            search_limit,
            widget_css,
            pdf_path,
            excluded_folders,
            allowed_extensions,
            protected_patterns,
            updated_at
        ) VALUES (
            'inline',
            50,
            '',
            '',
            '[]',
            '[\"html\",\"htm\",\"php\",\"txt\",\"pdf\"]',
            'config.php, *.db, .env, *.sql, *.key',
            datetime('now')
        )
    ")->execute();


    // ----- SEARCH LOGS ---------------
    $pdo->exec("
        CREATE TABLE search_logs (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            query TEXT,
            found INTEGER,
            ip TEXT,
            created_at TEXT
        )
    ");


    // ----- PDF INDEX (NEU & FIXED) ----
    $pdo->exec("
        CREATE TABLE pdf_index (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            path TEXT NOT NULL,
            title TEXT,
            content TEXT NOT NULL,
            pages INTEGER,
            last_index TEXT NOT NULL
        )
    ");

    // ⭐ WICHTIG: Duplikate verhindern!
    $pdo->exec("
        CREATE UNIQUE INDEX IF NOT EXISTS pdf_index_path_unique
        ON pdf_index(path)
    ");
}

/*
    ======================================================
       WEITERLEITEN ZUM LOGIN
    ======================================================
*/
header("Location: login.php");
exit;
