<?php
header('Content-Type: application/json; charset=utf-8');
// 2026 Volker Niederastroth

$dbDir  = __DIR__ . '/../data';
$dbFile = $dbDir . '/events.sqlite';

if (!is_dir($dbDir)) {
    mkdir($dbDir, 0775, true);
}

$db = new PDO('sqlite:' . $dbFile);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

/* Tabelle automatisch anlegen */
$db->exec("
CREATE TABLE IF NOT EXISTS events (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    event_date TEXT NOT NULL,
    event_time TEXT DEFAULT '',
    title TEXT NOT NULL,
    time_html TEXT NOT NULL,
    desc TEXT DEFAULT '',
    link TEXT DEFAULT '',
    created_at TEXT DEFAULT (datetime('now')),
    updated_at TEXT DEFAULT (datetime('now'))
);
");

$db->exec("CREATE INDEX IF NOT EXISTS idx_events_date ON events(event_date);");

$from = $_GET['from'] ?? null;
$to   = $_GET['to'] ?? null;

$sql = "SELECT event_date, event_time, title, time_html, desc, link FROM events";
$params = [];

if ($from && $to) {
    $sql .= " WHERE event_date BETWEEN :from AND :to";
    $params[':from'] = $from;
    $params[':to']   = $to;
}

$sql .= " ORDER BY event_date ASC, id ASC";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

$events = [];

foreach ($rows as $r) {
    $date = str_replace('.', '-', $r['event_date']);
    if (!isset($events[$date])) {
        $events[$date] = [];
    }

    $events[$date][] = [
        'title' => $r['title'],
        'clock' => $r['event_time'],   // ⏰
        'time'  => $r['time_html'],
        'desc'  => $r['desc'],
        'link'  => $r['link']
    ];
}

echo json_encode($events, JSON_UNESCAPED_UNICODE);
