<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/functions.php';

$cfg = read_config();

// --- Formularwerte übernehmen ---
$cfg['watermark_type'] = $_POST['watermark_type'] ?? 'text';
$cfg['watermark_text'] = trim($_POST['watermark_text'] ?? '© Volker');

$cfg['opacity']     = max(0,   min(100, (int)($_POST['opacity'] ?? 60)));
$cfg['font_size']   = max(10,  min(120, (int)($_POST['font_size'] ?? 40)));
$cfg['image_scale'] = max(0,   min(200, (int)($_POST['image_scale'] ?? 40)));

$cfg['position']   = $_POST['position']   ?? 'bottom-right';
$cfg['source_dir'] = trim($_POST['source_dir'] ?? 'bilder');
$cfg['output_dir'] = trim($_POST['output_dir'] ?? 'bilder/watermarked');

// -------- Schrift speichern --------
$postedFont = trim($_POST['font_file'] ?? '');
if ($postedFont !== '') {
  // Immer auf assets/<Datei> normalisieren
  $basename = basename($postedFont);
  $candidate = __DIR__ . '/assets/' . $basename;
  if (is_file($candidate) && is_readable($candidate)) {
    $cfg['font_file'] = 'assets/' . $basename;
  }
}
// Fallback, falls noch nie gesetzt / Datei fehlt
if (empty($cfg['font_file'])) {
  $cfg['font_file'] = 'assets/DejaVuSans.ttf';
}

// -------- Schriftfarbe speichern --------
$postedColor = trim($_POST['color'] ?? '');
if (preg_match('/^#[0-9A-Fa-f]{6}$/', $postedColor)) {
  $cfg['color'] = $postedColor;
} elseif (empty($cfg['color'])) {
  $cfg['color'] = '#ffffff'; // Standard: Weiß
}

// Optional: neuen Ausgabeordner anlegen
if (!empty($_POST['new_output_dir'])) {
  $new = trim($_POST['new_output_dir']);
  if ($new !== '') {
    $target = __DIR__ . '/' . ltrim($new, '/');
    if (!is_dir($target)) @mkdir($target, 0777, true);
    $cfg['output_dir'] = ltrim($new, '/');
  }
}

// Optional: Bild-Wasserzeichen hochladen (mit Auto-Resize)
if (!empty($_FILES['watermark_image_file']['tmp_name'])) {
  $uploadDir = __DIR__ . '/watermarks';
  if (!is_dir($uploadDir)) @mkdir($uploadDir, 0777, true);

  $ext = strtolower(pathinfo($_FILES['watermark_image_file']['name'], PATHINFO_EXTENSION));
  if (in_array($ext, ['png','jpg','jpeg','webp','gif'])) {
    $target = $uploadDir . '/wm.' . $ext;
    if (move_uploaded_file($_FILES['watermark_image_file']['tmp_name'], $target)) {
      // Auto-Verkleinerung auf max 1200 px
      [$wW, $wH, $wT] = getimagesize($target);
      $maxSize = 1200;
      if ($wW > $maxSize || $wH > $maxSize) {
        $ratio = min($maxSize / $wW, $maxSize / $wH);
        $newW = max(1, (int)($wW * $ratio));
        $newH = max(1, (int)($wH * $ratio));
        switch ($wT) {
          case IMAGETYPE_PNG:  $src = imagecreatefrompng($target);  break;
          case IMAGETYPE_JPEG: $src = imagecreatefromjpeg($target); break;
          case IMAGETYPE_WEBP: $src = imagecreatefromwebp($target); break;
          case IMAGETYPE_GIF:  $src = imagecreatefromgif($target);  break;
          default: $src = null;
        }
        if ($src) {
          $res = imagecreatetruecolor($newW, $newH);
          imagealphablending($res, false);
          imagesavealpha($res, true);
          imagecopyresampled($res, $src, 0, 0, 0, 0, $newW, $newH, $wW, $wH);
          // Immer als PNG speichern, um Alpha zu behalten
          imagepng($res, $target);
          imagedestroy($src);
          imagedestroy($res);
        }
      }
      $cfg['watermark_image'] = 'watermarks/wm.' . $ext;
    }
  }
}

save_config($cfg);
header('Location: index.php?saved=1');
exit;
